/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.spi.BootstrapContext;

public class ManagedResourcesImpl
implements ManagedResources {
    private Map<Class, ConverterDescriptor> attributeConverterDescriptorMap = new HashMap<Class, ConverterDescriptor>();
    private Set<Class> annotatedClassReferences = new LinkedHashSet<Class>();
    private Set<String> annotatedClassNames = new LinkedHashSet<String>();
    private Set<String> annotatedPackageNames = new LinkedHashSet<String>();
    private List<Binding> mappingFileBindings = new ArrayList<Binding>();
    private Map<String, Class<?>> extraQueryImports;

    public static ManagedResourcesImpl baseline(MetadataSources sources, BootstrapContext bootstrapContext) {
        ManagedResourcesImpl impl = new ManagedResourcesImpl();
        bootstrapContext.getAttributeConverters().forEach(impl::addAttributeConverterDefinition);
        impl.annotatedClassReferences.addAll(sources.getAnnotatedClasses());
        impl.annotatedClassNames.addAll(sources.getAnnotatedClassNames());
        impl.annotatedPackageNames.addAll(sources.getAnnotatedPackages());
        impl.mappingFileBindings.addAll(sources.getXmlBindings());
        impl.extraQueryImports = sources.getExtraQueryImports();
        return impl;
    }

    private ManagedResourcesImpl() {
    }

    @Override
    public Collection<ConverterDescriptor> getAttributeConverterDescriptors() {
        return Collections.unmodifiableCollection(this.attributeConverterDescriptorMap.values());
    }

    @Override
    public Collection<Class> getAnnotatedClassReferences() {
        return Collections.unmodifiableSet(this.annotatedClassReferences);
    }

    @Override
    public Collection<String> getAnnotatedClassNames() {
        return Collections.unmodifiableSet(this.annotatedClassNames);
    }

    @Override
    public Collection<String> getAnnotatedPackageNames() {
        return Collections.unmodifiableSet(this.annotatedPackageNames);
    }

    @Override
    public Collection<Binding> getXmlMappingBindings() {
        return Collections.unmodifiableList(this.mappingFileBindings);
    }

    @Override
    public Map<String, Class<?>> getExtraQueryImports() {
        return this.extraQueryImports;
    }

    @Internal
    public void addAttributeConverterDefinition(ConverterDescriptor descriptor) {
        this.attributeConverterDescriptorMap.put(descriptor.getAttributeConverterClass(), descriptor);
    }

    @Internal
    public void addAnnotatedClassReference(Class annotatedClassReference) {
        this.annotatedClassReferences.add(annotatedClassReference);
    }

    @Internal
    public void addAnnotatedClassName(String annotatedClassName) {
        this.annotatedClassNames.add(annotatedClassName);
    }

    @Internal
    public void addAnnotatedPackageName(String annotatedPackageName) {
        this.annotatedPackageNames.add(annotatedPackageName);
    }

    @Internal
    public void addXmlBinding(Binding binding) {
        this.mappingFileBindings.add(binding);
    }
}

