/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class VersionResolution<E>
implements BasicValue.Resolution<E> {
    private final JavaType javaType;
    private final JdbcType jdbcType;
    private final JdbcMapping jdbcMapping;
    private final BasicType legacyType;

    public static <E> VersionResolution<E> from(Function<TypeConfiguration, Type> implicitJavaTypeAccess, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, final TimeZoneStorageType timeZoneStorageType, final TypeConfiguration typeConfiguration, final MetadataBuildingContext context) {
        Type implicitJavaType = implicitJavaTypeAccess.apply(typeConfiguration);
        JavaType registered = typeConfiguration.getJavaTypeRegistry().resolveDescriptor(implicitJavaType);
        BasicJavaType jtd = (BasicJavaType)registered;
        JdbcType recommendedJdbcType = jtd.getRecommendedJdbcType(new JdbcTypeIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public TemporalType getTemporalPrecision() {
                return TemporalType.TIMESTAMP;
            }

            @Override
            public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
                if (timeZoneStorageType != null) {
                    switch (timeZoneStorageType) {
                        case COLUMN: {
                            return TimeZoneStorageStrategy.COLUMN;
                        }
                        case NATIVE: {
                            return TimeZoneStorageStrategy.NATIVE;
                        }
                        case NORMALIZE: {
                            return TimeZoneStorageStrategy.NORMALIZE;
                        }
                        case NORMALIZE_UTC: {
                            return TimeZoneStorageStrategy.NORMALIZE_UTC;
                        }
                    }
                }
                return context.getBuildingOptions().getDefaultTimeZoneStorage();
            }

            @Override
            public int getPreferredSqlTypeCodeForBoolean() {
                return context.getPreferredSqlTypeCodeForBoolean();
            }

            @Override
            public int getPreferredSqlTypeCodeForDuration() {
                return context.getPreferredSqlTypeCodeForDuration();
            }

            @Override
            public int getPreferredSqlTypeCodeForUuid() {
                return context.getPreferredSqlTypeCodeForUuid();
            }

            @Override
            public int getPreferredSqlTypeCodeForInstant() {
                return context.getPreferredSqlTypeCodeForInstant();
            }

            @Override
            public int getPreferredSqlTypeCodeForArray() {
                return context.getPreferredSqlTypeCodeForArray();
            }
        });
        BasicType basicType = typeConfiguration.getBasicTypeRegistry().resolve(jtd, recommendedJdbcType);
        BasicType legacyType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(jtd.getJavaType());
        assert (legacyType.getJdbcType().getJdbcTypeCode() == recommendedJdbcType.getJdbcTypeCode());
        return new VersionResolution<E>(jtd, recommendedJdbcType, basicType, legacyType);
    }

    public VersionResolution(JavaType javaType, JdbcType jdbcType, JdbcMapping jdbcMapping, BasicType legacyType) {
        this.javaType = javaType;
        this.jdbcType = jdbcType;
        this.jdbcMapping = jdbcMapping;
        this.legacyType = legacyType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public BasicType getLegacyResolvedBasicType() {
        return this.legacyType;
    }

    @Override
    public JavaType<E> getDomainJavaType() {
        return this.javaType;
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.javaType;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public BasicValueConverter<E, E> getValueConverter() {
        return this.legacyType.getValueConverter();
    }

    @Override
    public MutabilityPlan<E> getMutabilityPlan() {
        return ImmutableMutabilityPlan.instance();
    }
}

