/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.micrometer.MicrometerCollectorService;
import org.wildfly.extension.micrometer.MicrometerContextService;
import org.wildfly.extension.micrometer.MicrometerDependencyProcessor;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerRegistryService;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.MicrometerSubsystemDeploymentProcessor;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final MicrometerSubsystemAdd INSTANCE = new MicrometerSubsystemAdd();

    MicrometerSubsystemAdd() {
        super(MicrometerSubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final List exposedSubsystems = MicrometerSubsystemDefinition.EXPOSED_SUBSYSTEMS.unwrap((ExpressionResolver)context, model);
        final boolean exposeAnySubsystem = exposedSubsystems.remove("*");
        boolean securityEnabled = MicrometerSubsystemDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean();
        final Supplier<WildFlyRegistry> registrySupplier = MicrometerRegistryService.install(context);
        Supplier<MicrometerCollector> collectorSupplier = MicrometerCollectorService.install(context);
        MicrometerContextService.install(context, securityEnabled);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("micrometer", Phase.DEPENDENCIES, 6416, (DeploymentUnitProcessor)new MicrometerDependencyProcessor());
                processorTarget.addDeploymentProcessor("micrometer", Phase.POST_MODULE, 14164, (DeploymentUnitProcessor)new MicrometerSubsystemDeploymentProcessor(exposeAnySubsystem, exposedSubsystems, registrySupplier));
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((operationContext, modelNode) -> {
            MicrometerCollector micrometerCollector = (MicrometerCollector)collectorSupplier.get();
            if (micrometerCollector == null) {
                throw new IllegalStateException();
            }
            ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
            Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            micrometerCollector.collectResourceMetrics(rootResource, rootResourceRegistration, Function.identity(), exposeAnySubsystem, exposedSubsystems);
        }, OperationContext.Stage.VERIFY);
        MicrometerExtensionLogger.MICROMETER_LOGGER.activatingSubsystem();
    }
}

