/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.metrics;

import io.micrometer.core.instrument.Meter;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.extension.micrometer.metrics.WildFlyMetric;
import org.wildfly.extension.micrometer.metrics.WildFlyMetricMetadata;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

public class MetricRegistration {
    private final List<Runnable> registrationTasks = new ArrayList<Runnable>();
    private final List<Meter.Id> unregistrationTasks = new ArrayList<Meter.Id>();
    private final WildFlyRegistry registry;

    public MetricRegistration(WildFlyRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        WildFlyRegistry wildFlyRegistry = this.registry;
        synchronized (wildFlyRegistry) {
            for (Runnable task : this.registrationTasks) {
                task.run();
            }
            this.registrationTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        WildFlyRegistry wildFlyRegistry = this.registry;
        synchronized (wildFlyRegistry) {
            for (Meter.Id id : this.unregistrationTasks) {
                this.registry.remove(id);
            }
            this.unregistrationTasks.clear();
        }
    }

    public void registerMetric(WildFlyMetric metric, WildFlyMetricMetadata metadata) {
        this.unregistrationTasks.add(this.registry.addMeter(metric, metadata).getId());
    }

    public synchronized void addRegistrationTask(Runnable task) {
        this.registrationTasks.add(task);
    }
}

