/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.TransportInput;

public class ByteBufferUtils {
    public static int pour(ByteBuffer source, ByteBuffer destination) {
        int numberOfBytesToPour = Math.min(source.remaining(), destination.remaining());
        ByteBuffer sourceSubBuffer = source.duplicate();
        sourceSubBuffer.limit(sourceSubBuffer.position() + numberOfBytesToPour);
        destination.put(sourceSubBuffer);
        source.position(source.position() + numberOfBytesToPour);
        return numberOfBytesToPour;
    }

    public static int pourArrayToBuffer(byte[] source, int offset, int sizeRequested, ByteBuffer destination) {
        int numberToWrite = Math.min(destination.remaining(), sizeRequested);
        destination.put(source, offset, numberToWrite);
        return numberToWrite;
    }

    public static int pourAll(ByteBuffer source, TransportInput destinationTransportInput) throws TransportException {
        int capacity = destinationTransportInput.capacity();
        if (capacity == -1) {
            if (source.hasRemaining()) {
                throw new IllegalStateException("Destination has reached end of stream: " + destinationTransportInput);
            }
            return -1;
        }
        int total = source.remaining();
        while (source.hasRemaining() && destinationTransportInput.capacity() > 0) {
            ByteBufferUtils.pour(source, destinationTransportInput.tail());
            destinationTransportInput.process();
        }
        return total - source.remaining();
    }

    public static int pourBufferToArray(ByteBuffer source, byte[] destination, int offset, int sizeRequested) {
        int numberToRead = Math.min(source.remaining(), sizeRequested);
        source.get(destination, offset, numberToRead);
        return numberToRead;
    }

    public static ByteBuffer newWriteableBuffer(int capacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        return newBuffer;
    }

    public static ByteBuffer newReadableBuffer(int capacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        newBuffer.flip();
        return newBuffer;
    }
}

