/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.spi.EntityOutputStream;

public class ResteasyEntityPartBuilder
implements EntityPart.Builder {
    private static final Annotation[] ANNOTATIONS = new Annotation[0];
    private final String name;
    private final MultivaluedMap<String, String> headers;
    private MediaType mediaType;
    private String fileName;
    private Content content;

    public ResteasyEntityPartBuilder(String name) {
        this.name = name;
        this.headers = new MultivaluedHashMap();
    }

    public EntityPart.Builder mediaType(MediaType mediaType) throws IllegalArgumentException {
        this.mediaType = mediaType;
        return this;
    }

    public EntityPart.Builder mediaType(String mediaTypeString) throws IllegalArgumentException {
        this.mediaType = mediaTypeString == null ? null : MediaType.valueOf((String)mediaTypeString);
        return this;
    }

    public EntityPart.Builder header(String headerName, String ... headerValues) throws IllegalArgumentException {
        this.headers.addAll((Object)headerName, (Object[])headerValues);
        return this;
    }

    public EntityPart.Builder headers(MultivaluedMap<String, String> newHeaders) throws IllegalArgumentException {
        this.headers.putAll(newHeaders);
        return this;
    }

    public EntityPart.Builder fileName(String fileName) throws IllegalArgumentException {
        this.fileName = fileName;
        return this;
    }

    public EntityPart.Builder content(InputStream content) throws IllegalArgumentException {
        this.content = new Content(GenericType.forInstance((Object)Objects.requireNonNull(content, Messages.MESSAGES.nullParameter("content"))), content);
        return this;
    }

    public <T> EntityPart.Builder content(T content, Class<? extends T> type) throws IllegalArgumentException {
        this.content = new Content(new GenericType((Type)Objects.requireNonNull(type, Messages.MESSAGES.nullParameter("type"))), Objects.requireNonNull(content, Messages.MESSAGES.nullParameter("content")));
        return this;
    }

    public EntityPart.Builder content(Object content) throws IllegalArgumentException {
        return this.content(Objects.requireNonNull(content, Messages.MESSAGES.nullParameter("content")), content.getClass());
    }

    public <T> EntityPart.Builder content(T content, GenericType<T> type) throws IllegalArgumentException {
        this.content = new Content(Objects.requireNonNull(type, Messages.MESSAGES.nullParameter("type")), Objects.requireNonNull(content, Messages.MESSAGES.nullParameter("content")));
        return this;
    }

    public EntityPart build() throws IllegalStateException, IOException, WebApplicationException {
        return new EntityPartImpl(this.name, this.headers, this.mediaType, this.fileName, this.content);
    }

    private static class Content {
        final GenericType<?> genericType;
        final Object content;
        final InputPart inputPart;

        private Content(GenericType<?> genericType, Object content) {
            this.genericType = genericType;
            this.content = content;
            this.inputPart = null;
        }

        InputStream getInputStream(MediaType mediaType, MultivaluedMap<String, String> headers) throws IOException {
            if (this.content instanceof InputStream) {
                return (InputStream)this.content;
            }
            if (this.content instanceof EntityPart) {
                return ((EntityPart)this.content).getContent();
            }
            if (this.content instanceof InputPart) {
                return ((InputPart)this.content).getBody();
            }
            try (EntityOutputStream out = new EntityOutputStream();){
                Providers providers = (Providers)ResteasyContext.getRequiredContextData(Providers.class);
                MessageBodyWriter messageBodyWriter = providers.getMessageBodyWriter(this.genericType.getRawType(), this.genericType.getType(), ANNOTATIONS, mediaType);
                messageBodyWriter.writeTo(this.content, this.genericType.getRawType(), this.genericType.getType(), ANNOTATIONS, mediaType, (MultivaluedMap)new MultivaluedHashMap(headers), (OutputStream)out);
                InputStream inputStream = out.toInputStream();
                return inputStream;
            }
        }

        public String toString() {
            return String.format("Content[content=%s, genericType=%s]", this.content, this.genericType);
        }
    }

    private static class EntityPartImpl
    implements EntityPart {
        private final String name;
        private final MultivaluedMap<String, String> headers;
        private final MediaType mediaType;
        private final String fileName;
        private final Content content;

        private EntityPartImpl(String name, MultivaluedMap<String, String> headers, MediaType mediaType, String fileName, Content content) {
            this.name = name;
            this.headers = new UnmodifiableMultivaluedMap((MultivaluedMap)new MultivaluedHashMap(headers));
            this.mediaType = mediaType;
            this.fileName = fileName;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getFileName() {
            return Optional.ofNullable(this.fileName);
        }

        public InputStream getContent() {
            try {
                return this.content.getInputStream(this.mediaType, this.headers);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public <T> T getContent(Class<T> type) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
            return this.getContent(new GenericType(type));
        }

        public <T> T getContent(GenericType<T> type) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
            Providers providers = (Providers)ResteasyContext.getRequiredContextData(Providers.class);
            MessageBodyReader reader = providers.getMessageBodyReader(type.getRawType(), type.getType(), ANNOTATIONS, this.mediaType);
            if (reader == null) {
                throw new RuntimeException(Messages.MESSAGES.unableToFindMessageBodyReader(this.mediaType, type.getRawType().getName()));
            }
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
            return (T)reader.readFrom(type.getRawType(), type.getType(), ANNOTATIONS, this.mediaType, this.headers, this.getContent());
        }

        public MultivaluedMap<String, String> getHeaders() {
            return this.headers;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public String toString() {
            return String.format("EntityPart[name=%s, fileName=%s, mediaType=%s, headers=%s, content=%s]", this.name, this.fileName, this.mediaType, this.headers, this.content);
        }
    }
}

