/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ClusterDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ClusterTarget {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final List<Agent> membersInShardOrder;
    final List<Agent> excluded;
    final ClusterDescriptor descriptor;

    static ClusterTarget create(List<Agent> allAgentsInIdOrder) {
        Agent[] candidatesInIdOrder = allAgentsInIdOrder.toArray(new Agent[0]);
        ArrayList<Agent> membersInShardOrder = new ArrayList<Agent>();
        ArrayList<Agent> excluded = new ArrayList<Agent>();
        ClusterTarget.assignStaticAgents(candidatesInIdOrder, membersInShardOrder);
        boolean hasStaticAgent = !membersInShardOrder.isEmpty();
        ClusterTarget.assignDynamicAgents(candidatesInIdOrder, hasStaticAgent, membersInShardOrder, excluded);
        return new ClusterTarget(membersInShardOrder, excluded);
    }

    private static void assignStaticAgents(Agent[] candidatesInIdOrder, List<Agent> membersInShardOrder) {
        Agent firstStaticAgent = null;
        Integer firstStaticAgentTotalShardCount = null;
        for (int i = 0; i < candidatesInIdOrder.length; ++i) {
            Agent previouslyAssigned;
            Agent agent = candidatesInIdOrder[i];
            if (!AgentType.EVENT_PROCESSING_STATIC_SHARDING.equals((Object)agent.getType())) continue;
            ShardAssignmentDescriptor agentStaticShardAssignment = agent.getShardAssignment();
            int agentTotalShardCount = agentStaticShardAssignment.totalShardCount;
            if (firstStaticAgentTotalShardCount == null) {
                firstStaticAgent = agent;
                firstStaticAgentTotalShardCount = agentTotalShardCount;
                while (membersInShardOrder.size() < firstStaticAgentTotalShardCount) {
                    membersInShardOrder.add(null);
                }
            } else if (!firstStaticAgentTotalShardCount.equals(agentTotalShardCount)) {
                throw log.conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding(agent.getReference(), agentStaticShardAssignment, firstStaticAgent.getReference(), firstStaticAgentTotalShardCount);
            }
            if ((previouslyAssigned = membersInShardOrder.set(agentStaticShardAssignment.assignedShardIndex, agent)) != null) {
                throw log.conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding(agent.getReference(), agentStaticShardAssignment, previouslyAssigned.getReference());
            }
            candidatesInIdOrder[i] = null;
        }
    }

    private static void assignDynamicAgents(Agent[] candidatesInIdOrder, boolean hasStaticAgent, List<Agent> membersInShardOrder, List<Agent> excluded) {
        int j = 0;
        for (int i = 0; i < candidatesInIdOrder.length; ++i) {
            if (candidatesInIdOrder[i] == null) continue;
            while (j < membersInShardOrder.size() && membersInShardOrder.get(j) != null) {
                ++j;
            }
            if (j < membersInShardOrder.size()) {
                membersInShardOrder.set(j, candidatesInIdOrder[i]);
                continue;
            }
            if (!hasStaticAgent) {
                membersInShardOrder.add(candidatesInIdOrder[i]);
                continue;
            }
            excluded.add(candidatesInIdOrder[i]);
        }
    }

    private ClusterTarget(List<Agent> membersInShardOrder, List<Agent> excluded) {
        this.membersInShardOrder = Collections.unmodifiableList(membersInShardOrder);
        this.excluded = Collections.unmodifiableList(excluded);
        ArrayList<Long> memberIdsInShardOrder = new ArrayList<Long>(membersInShardOrder.size());
        for (Agent member : membersInShardOrder) {
            memberIdsInShardOrder.add(member == null ? null : member.getId());
        }
        this.descriptor = new ClusterDescriptor(memberIdsInShardOrder);
    }
}

