/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.jboss.logging.Logger;
import org.junit.Before;
import org.junit.Test;

public class MessageConcurrencyTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(MessageConcurrencyTest.class);
    private ActiveMQServer server;
    private final SimpleString ADDRESS = new SimpleString("MessageConcurrencyTestAddress");
    private final SimpleString QUEUE_NAME = new SimpleString("MessageConcurrencyTestQueue");
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testMessageConcurrency() throws Exception {
        int i;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession createSession = sf.createSession();
        HashSet<ClientSession> sendSessions = new HashSet<ClientSession>();
        HashSet<Sender> senders = new HashSet<Sender>();
        int numSessions = 100;
        int numMessages = 1000;
        for (i = 0; i < 100; ++i) {
            ClientSession sendSession = sf.createSession();
            sendSessions.add(sendSession);
            ClientProducer producer = sendSession.createProducer(this.ADDRESS);
            Sender sender = new Sender(1000, producer);
            senders.add(sender);
            sender.start();
        }
        for (i = 0; i < 1000; ++i) {
            byte[] body = RandomUtil.randomBytes((int)1000);
            ClientMessage message = createSession.createMessage(false);
            message.getBodyBuffer().writeBytes(body);
            for (Sender sender : senders) {
                sender.queue.add(message);
            }
        }
        for (Sender sender : senders) {
            sender.join();
            MessageConcurrencyTest.assertFalse((boolean)sender.failed);
        }
        for (ClientSession sendSession : sendSessions) {
            sendSession.close();
        }
        createSession.close();
        sf.close();
    }

    @Test
    public void testMessageConcurrencyAfterConsumption() throws Exception {
        int i;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession consumeSession = sf.createSession();
        ClientProducer mainProducer = consumeSession.createProducer(this.ADDRESS);
        consumeSession.createQueue(new QueueConfiguration(this.QUEUE_NAME).setAddress(this.ADDRESS));
        ClientConsumer consumer = consumeSession.createConsumer(this.QUEUE_NAME);
        consumeSession.start();
        HashSet<ClientSession> sendSessions = new HashSet<ClientSession>();
        final HashSet<Sender> senders = new HashSet<Sender>();
        int numSessions = 100;
        int numMessages = 1000;
        for (i = 0; i < 100; ++i) {
            ClientSession sendSession = sf.createSession();
            sendSessions.add(sendSession);
            ClientProducer producer = sendSession.createProducer(this.ADDRESS);
            Sender sender = new Sender(1000, producer);
            senders.add(sender);
            sender.start();
        }
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                for (Sender sender : senders) {
                    sender.queue.add(message);
                }
            }
        });
        for (i = 0; i < 1000; ++i) {
            byte[] body = RandomUtil.randomBytes((int)1000);
            ClientMessage message = consumeSession.createMessage(false);
            message.getBodyBuffer().writeBytes(body);
            mainProducer.send((Message)message);
        }
        for (Sender sender : senders) {
            sender.join();
            MessageConcurrencyTest.assertFalse((boolean)sender.failed);
        }
        for (ClientSession sendSession : sendSessions) {
            sendSession.close();
        }
        consumer.close();
        consumeSession.deleteQueue(this.QUEUE_NAME);
        consumeSession.close();
        sf.close();
    }

    private class Sender
    extends Thread {
        private final BlockingQueue<ClientMessage> queue = new LinkedBlockingQueue<ClientMessage>();
        private final ClientProducer producer;
        private final int numMessages;
        volatile boolean failed;

        Sender(int numMessages, ClientProducer producer) {
            this.numMessages = numMessages;
            this.producer = producer;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.numMessages; ++i) {
                    ClientMessage msg = this.queue.take();
                    this.producer.send((Message)msg);
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to send message", (Throwable)e);
                this.failed = true;
            }
        }
    }
}

