/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.SymmetricClusterTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class SymmetricClusterWithBackupTest
extends SymmetricClusterTest {
    @Override
    @Test
    public void testStopAllStartAll() throws Throwable {
        try {
            this.setupCluster();
            this.startServers();
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            this.setupSessionFactory(2, this.isNetty());
            this.setupSessionFactory(3, this.isNetty());
            this.setupSessionFactory(4, this.isNetty());
            this.createQueue(0, "queues.testaddress", "queue0", null, false);
            this.createQueue(1, "queues.testaddress", "queue0", null, false);
            this.createQueue(2, "queues.testaddress", "queue0", null, false);
            this.createQueue(3, "queues.testaddress", "queue0", null, false);
            this.createQueue(4, "queues.testaddress", "queue0", null, false);
            this.addConsumer(0, 0, "queue0", null);
            this.addConsumer(1, 1, "queue0", null);
            this.addConsumer(2, 2, "queue0", null);
            this.addConsumer(3, 3, "queue0", null);
            this.addConsumer(4, 4, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 1, true);
            this.waitForBindings(1, "queues.testaddress", 1, 1, true);
            this.waitForBindings(2, "queues.testaddress", 1, 1, true);
            this.waitForBindings(3, "queues.testaddress", 1, 1, true);
            this.waitForBindings(4, "queues.testaddress", 1, 1, true);
            this.waitForBindings(0, "queues.testaddress", 4, 4, false);
            this.waitForBindings(1, "queues.testaddress", 4, 4, false);
            this.waitForBindings(2, "queues.testaddress", 4, 4, false);
            this.waitForBindings(3, "queues.testaddress", 4, 4, false);
            this.waitForBindings(4, "queues.testaddress", 4, 4, false);
            this.send(0, "queues.testaddress", 10, false, null);
            this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
            this.verifyNotReceive(0, 1, 2, 3, 4);
            this.closeAllConsumers();
            this.closeAllSessionFactories();
            this.closeAllServerLocatorsFactories();
            this.stopServers();
            this.startServers();
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            this.setupSessionFactory(2, this.isNetty());
            this.setupSessionFactory(3, this.isNetty());
            this.setupSessionFactory(4, this.isNetty());
            this.createQueue(0, "queues.testaddress", "queue0", null, false);
            this.createQueue(1, "queues.testaddress", "queue0", null, false);
            this.createQueue(2, "queues.testaddress", "queue0", null, false);
            this.createQueue(3, "queues.testaddress", "queue0", null, false);
            this.createQueue(4, "queues.testaddress", "queue0", null, false);
            this.addConsumer(0, 0, "queue0", null);
            this.addConsumer(1, 1, "queue0", null);
            this.addConsumer(2, 2, "queue0", null);
            this.addConsumer(3, 3, "queue0", null);
            this.addConsumer(4, 4, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 1, true);
            this.waitForBindings(1, "queues.testaddress", 1, 1, true);
            this.waitForBindings(2, "queues.testaddress", 1, 1, true);
            this.waitForBindings(3, "queues.testaddress", 1, 1, true);
            this.waitForBindings(4, "queues.testaddress", 1, 1, true);
            this.waitForBindings(0, "queues.testaddress", 4, 4, false);
            this.waitForBindings(1, "queues.testaddress", 4, 4, false);
            this.waitForBindings(2, "queues.testaddress", 4, 4, false);
            this.waitForBindings(3, "queues.testaddress", 4, 4, false);
            this.waitForBindings(4, "queues.testaddress", 4, 4, false);
            this.send(0, "queues.testaddress", 10, false, null);
            this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
            this.verifyNotReceive(0, 1, 2, 3, 4);
        }
        catch (Throwable e) {
            System.out.println(ActiveMQTestBase.threadDump((String)"SymmetricClusterWithBackupTest::testStopAllStartAll"));
            throw e;
        }
    }

    @Override
    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesAddQueuesAndConsumersBeforeAllServersAreStarted() throws Exception {
        this.setupCluster();
        this.startServers(5, 0);
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(5, 0, "queue5", null);
        this.startServers(6, 1);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(16, 1, "queue15", null);
        this.startServers(7, 2);
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(17, 2, "queue15", null);
        this.startServers(8, 3);
        this.setupSessionFactory(3, this.isNetty());
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(18, 3, "queue15", null);
        this.startServers(9, 4);
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
    }

    @Override
    public void _testStartStopServers() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(16, 1, "queue15", null);
        this.addConsumer(17, 2, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
        this.removeConsumer(0);
        this.removeConsumer(5);
        this.removeConsumer(10);
        this.removeConsumer(15);
        this.removeConsumer(23);
        this.removeConsumer(3);
        this.removeConsumer(8);
        this.removeConsumer(13);
        this.removeConsumer(18);
        this.removeConsumer(21);
        this.removeConsumer(26);
        this.closeSessionFactory(0);
        this.closeSessionFactory(3);
        this.stopServers(5, 8, 0, 3);
        this.startServers(0, 3, 5, 8);
        Thread.sleep(2000L);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
    }

    @Override
    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnectionWithBackups("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, new int[]{1, 2, 3, 4});
        this.setupClusterConnectionWithBackups("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, new int[]{0, 2, 3, 4});
        this.setupClusterConnectionWithBackups("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, new int[]{0, 1, 3, 4});
        this.setupClusterConnectionWithBackups("cluster3", "queues", messageLoadBalancingType, 1, this.isNetty(), 3, new int[]{0, 1, 2, 4});
        this.setupClusterConnectionWithBackups("cluster4", "queues", messageLoadBalancingType, 1, this.isNetty(), 4, new int[]{0, 1, 2, 3});
        this.setupClusterConnectionWithBackups("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 5, new int[]{0, 1, 2, 3, 4});
        this.setupClusterConnectionWithBackups("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 6, new int[]{0, 1, 2, 3, 4});
        this.setupClusterConnectionWithBackups("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 7, new int[]{0, 1, 2, 3, 4});
        this.setupClusterConnectionWithBackups("cluster3", "queues", messageLoadBalancingType, 1, this.isNetty(), 8, new int[]{0, 1, 2, 3, 4});
        this.setupClusterConnectionWithBackups("cluster4", "queues", messageLoadBalancingType, 1, this.isNetty(), 9, new int[]{0, 1, 2, 3, 4});
    }

    @Override
    protected void setupServers() throws Exception {
        this.setupBackupServer(5, 0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(6, 1, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(7, 2, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(8, 3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(9, 4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupLiveServer(0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupLiveServer(1, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupLiveServer(2, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupLiveServer(3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupLiveServer(4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
    }

    @Override
    protected void startServers() throws Exception {
        this.getServer(5).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration());
        this.getServer(6).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration());
        this.getServer(7).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration());
        this.getServer(8).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration());
        this.getServer(9).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration());
        this.startServers(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Override
    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(5, 6, 7, 8, 9, 0, 1, 2, 3, 4);
    }
}

