/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.quorum;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PluggableQuorumExtraBackupReplicatedFailoverTest
extends FailoverTestBase {
    private static final String GROUP_NAME = "foo";
    @Parameterized.Parameter
    public boolean useGroupName;

    @Parameterized.Parameters(name="useGroupName={0}")
    public static Iterable<Object[]> getParams() {
        return Arrays.asList({false}, {true});
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        if (this.useGroupName) {
            ((ReplicationPrimaryPolicyConfiguration)this.liveConfig.getHAPolicyConfiguration()).setGroupName(GROUP_NAME);
            ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setGroupName(GROUP_NAME);
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    @Test
    public void testExtraBackupReplicates() throws Exception {
        Configuration secondBackupConfig = this.backupConfig.copy();
        String secondBackupGroupName = ((ReplicationBackupPolicyConfiguration)secondBackupConfig.getHAPolicyConfiguration()).getGroupName();
        Assert.assertEquals((Object)((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).getGroupName(), (Object)secondBackupGroupName);
        if (this.useGroupName) {
            Assert.assertEquals((Object)GROUP_NAME, (Object)secondBackupGroupName);
        } else {
            Assert.assertNull((Object)secondBackupGroupName);
        }
        TestableServer secondBackupServer = this.createTestableServer(secondBackupConfig);
        secondBackupConfig.setBindingsDirectory(this.getBindingsDir(1, true)).setJournalDirectory(this.getJournalDir(1, true)).setPagingDirectory(this.getPageDir(1, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(1, true)).setSecurityEnabled(false);
        PluggableQuorumExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
        secondBackupServer.start();
        Thread.sleep(5000L);
        this.backupServer.stop();
        this.waitForSync(secondBackupServer.getServer());
        PluggableQuorumExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)secondBackupServer.getServer());
    }

    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }
}

