/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.remoting.compat;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.hornetq.client.HornetQClientProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class HQClientProtocolManagerTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoCheckFailoverMessage() throws Exception {
        int pingPeriod = 1000;
        ActiveMQServer server = this.createServer(false, true);
        server.start();
        ClientSessionInternal session = null;
        try {
            ServerLocator locator = this.createFactory(true).setClientFailureCheckPeriod(1000L).setRetryInterval(500L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(-1).setConfirmationWindowSize(0x100000);
            locator.setProtocolManagerFactory((ClientProtocolManagerFactory)new HornetQClientProtocolManagerFactory());
            ClientSessionFactory factory = this.createSessionFactory(locator);
            session = (ClientSessionInternal)factory.createSession();
            server.stop();
            Thread.sleep(2000L);
            List incomings = server.getConfiguration().getIncomingInterceptorClassNames();
            incomings.add(UnsupportedPacketInterceptor.class.getName());
            server.start();
            ClientSession.QueueQuery query = session.queueQuery(new SimpleString("anyvalue"));
            HQClientProtocolManagerTest.assertFalse((boolean)query.isExists());
            locator.close();
            UnsupportedPacketInterceptor.checkReceivedTypes();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
            server.stop();
        }
    }

    public static class UnsupportedPacketInterceptor
    implements Interceptor {
        private static Set<Byte> receivedTypes = new HashSet<Byte>();
        private static Set<Byte> unsupportedTypes = new HashSet<Byte>();

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            receivedTypes.add(packet.getType());
            return true;
        }

        public static void checkReceivedTypes() throws Exception {
            for (Byte type : receivedTypes) {
                Assert.assertFalse((String)("Received unsupported type: " + type), (boolean)unsupportedTypes.contains(type));
            }
        }

        static {
            unsupportedTypes.add((byte)-4);
        }
    }
}

