/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.jboss.logmanager.Level;
import org.junit.Test;

public class SimpleStartStopTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartStopAndCleanupIDs() throws Exception {
        AssertionLoggerHandler.clear();
        AssertionLoggerHandler.startCapture();
        try {
            ActiveMQServer server = null;
            for (int i = 0; i < 50; ++i) {
                server = this.createServer(true, false);
                server.start();
                server.fail(false);
            }
            SimpleStartStopTest.assertFalse((String)"There shouldn't be any error for just starting / stopping the server", (boolean)AssertionLoggerHandler.hasLevel((java.util.logging.Level)Level.ERROR));
            SimpleStartStopTest.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224008"}));
            HashMap records = this.internalCountJournalLivingRecords(server.getConfiguration(), false);
            AtomicInteger recordCount = (AtomicInteger)records.get(24);
            SimpleStartStopTest.assertNotNull((Object)recordCount);
            SimpleStartStopTest.assertTrue((String)("The server should cleanup after IDs on the bindings record. It left " + recordCount + " ids on the journal"), (recordCount.intValue() < 5 ? 1 : 0) != 0);
            server.start();
            records = this.internalCountJournalLivingRecords(server.getConfiguration(), false);
            recordCount = (AtomicInteger)records.get(24);
            SimpleStartStopTest.assertNotNull((Object)recordCount);
            SimpleStartStopTest.assertTrue((String)"If this is zero it means we are removing too many records", (recordCount.intValue() != 0 ? 1 : 0) != 0);
            server.stop();
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }
}

