/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrameInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class StompWithInterceptorsTest
extends StompTestBase {
    @Override
    public List<String> getIncomingInterceptors() {
        ArrayList<String> stompIncomingInterceptor = new ArrayList<String>();
        stompIncomingInterceptor.add(IncomingStompInterceptor.class.getName());
        stompIncomingInterceptor.add(CoreInterceptor.class.getName());
        return stompIncomingInterceptor;
    }

    @Override
    public List<String> getOutgoingInterceptors() {
        ArrayList<String> stompOutgoingInterceptor = new ArrayList<String>();
        stompOutgoingInterceptor.add(OutgoingStompInterceptor.class.getName());
        return stompOutgoingInterceptor;
    }

    @Test
    public void stompFrameInterceptor() throws Exception {
        IncomingStompInterceptor.interceptedFrames.clear();
        OutgoingStompInterceptor.interceptedFrames.clear();
        StompWithInterceptorsTest.assertTrue((boolean)Wait.waitFor(() -> {
            for (Packet packet : new ArrayList<Packet>(CoreInterceptor.incomingInterceptedFrames)) {
                if (packet.getType() != 67) continue;
                return true;
            }
            return false;
        }, (long)2000L, (long)50L));
        CoreInterceptor.incomingInterceptedFrames.clear();
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithInterceptorsTest.getQueuePrefix() + StompWithInterceptorsTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        StompWithInterceptorsTest.assertEquals((long)0L, (long)CoreInterceptor.incomingInterceptedFrames.size());
        this.sendJmsMessage(this.getName());
        StompWithInterceptorsTest.assertTrue((String)"core interceptor is not working", (CoreInterceptor.incomingInterceptedFrames.size() > 0 ? 1 : 0) != 0);
        conn.receiveFrame(10000L);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithInterceptorsTest.getQueuePrefix() + StompWithInterceptorsTest.getQueueName());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        StompWithInterceptorsTest.assertTrue((boolean)Wait.waitFor(() -> OutgoingStompInterceptor.interceptedFrames.size() == 3, (long)2000L, (long)50L));
        conn.disconnect();
        StompWithInterceptorsTest.assertTrue((boolean)Wait.waitFor(() -> IncomingStompInterceptor.interceptedFrames.size() == 4, (long)2000L, (long)50L));
        ArrayList<String> incomingCommands = new ArrayList<String>(4);
        incomingCommands.add("CONNECT");
        incomingCommands.add("SUBSCRIBE");
        incomingCommands.add("SEND");
        incomingCommands.add("DISCONNECT");
        for (int i = 0; i < IncomingStompInterceptor.interceptedFrames.size(); ++i) {
            Assert.assertEquals(incomingCommands.get(i), (Object)IncomingStompInterceptor.interceptedFrames.get(i).getCommand());
            Assert.assertEquals((Object)"incomingInterceptedVal", (Object)IncomingStompInterceptor.interceptedFrames.get(i).getHeader("incomingInterceptedProp"));
        }
        ArrayList<String> outgoingCommands = new ArrayList<String>(3);
        outgoingCommands.add("CONNECTED");
        outgoingCommands.add("MESSAGE");
        outgoingCommands.add("MESSAGE");
        for (int i = 0; i < OutgoingStompInterceptor.interceptedFrames.size(); ++i) {
            Assert.assertEquals(outgoingCommands.get(i), (Object)OutgoingStompInterceptor.interceptedFrames.get(i).getCommand());
        }
        Assert.assertEquals((Object)"incomingInterceptedVal", (Object)OutgoingStompInterceptor.interceptedFrames.get(2).getHeader("incomingInterceptedProp"));
        Assert.assertEquals((Object)"outgoingInterceptedVal", (Object)OutgoingStompInterceptor.interceptedFrames.get(2).getHeader("outgoingInterceptedProp"));
    }

    public static class OutgoingStompInterceptor
    implements StompFrameInterceptor {
        static List<StompFrame> interceptedFrames = Collections.synchronizedList(new ArrayList());

        public boolean intercept(StompFrame stompFrame, RemotingConnection connection) {
            interceptedFrames.add(stompFrame);
            stompFrame.addHeader("outgoingInterceptedProp", "outgoingInterceptedVal");
            return true;
        }
    }

    public static class IncomingStompInterceptor
    implements StompFrameInterceptor {
        static List<StompFrame> interceptedFrames = Collections.synchronizedList(new ArrayList());

        public boolean intercept(StompFrame stompFrame, RemotingConnection connection) {
            interceptedFrames.add(stompFrame);
            stompFrame.addHeader("incomingInterceptedProp", "incomingInterceptedVal");
            return true;
        }
    }

    public static class CoreInterceptor
    implements Interceptor {
        static List<Packet> incomingInterceptedFrames = new ArrayList<Packet>();

        public boolean intercept(Packet packet, RemotingConnection connection) {
            incomingInterceptedFrames.add(packet);
            return true;
        }
    }
}

