/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.Assert;
import org.junit.Test;

public class StompWithSecurityTest
extends StompTestBase {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Test
    public void testJMSXUserID() throws Exception {
        this.server.getConfiguration().setPopulateValidatedUser(true);
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithSecurityTest.getQueuePrefix() + StompWithSecurityTest.getQueueName());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        conn.disconnect();
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello World", (Object)message.getText());
        Assert.assertEquals((String)"getJMSPriority", (long)4L, (long)message.getJMSPriority());
        Assert.assertEquals((String)"JMSXUserID", (Object)"brianm", (Object)message.getStringProperty("JMSXUserID"));
        long tnow = System.currentTimeMillis();
        long tmsg = message.getJMSTimestamp();
        Assert.assertTrue((Math.abs(tnow - tmsg) < 1000L ? 1 : 0) != 0);
    }
}

