/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.FactoryFinder;
import jakarta.activation.FileTypeMap;
import jakarta.activation.LogSupport;
import jakarta.activation.MimeTypeRegistry;
import jakarta.activation.SecuritySupport;
import jakarta.activation.spi.MimeTypeRegistryProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.Vector;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private MimeTypeRegistry[] DB;
    private static final int PROG = 0;
    private static final String defaultType = "application/octet-stream";
    private static final String confDir;

    public MimetypesFileTypeMap() {
        MimeTypeRegistry mf;
        Vector<MimeTypeRegistry> dbv;
        block8: {
            block7: {
                dbv = new Vector<MimeTypeRegistry>(5);
                mf = null;
                dbv.addElement(null);
                LogSupport.log("MimetypesFileTypeMap: load HOME");
                try {
                    String path;
                    String user_home = System.getProperty("user.home");
                    if (user_home != null && (mf = this.loadFile(path = user_home + File.separator + ".mime.types")) != null) {
                        dbv.addElement(mf);
                    }
                }
                catch (SecurityException ex) {
                    if (!LogSupport.isLoggable()) break block7;
                    LogSupport.log("Exception during MimetypesFileTypeMap class instantiation", ex);
                }
            }
            LogSupport.log("MimetypesFileTypeMap: load SYS");
            try {
                if (confDir != null && (mf = this.loadFile(confDir + "mime.types")) != null) {
                    dbv.addElement(mf);
                }
            }
            catch (SecurityException ex) {
                if (!LogSupport.isLoggable()) break block8;
                LogSupport.log("Exception during MimetypesFileTypeMap class instantiation", ex);
            }
        }
        LogSupport.log("MimetypesFileTypeMap: load JAR");
        this.loadAllResources(dbv, "META-INF/mime.types");
        LogSupport.log("MimetypesFileTypeMap: load DEF");
        mf = this.loadResource("/META-INF/mimetypes.default");
        if (mf != null) {
            dbv.addElement(mf);
        }
        this.DB = new MimeTypeRegistry[dbv.size()];
        dbv.copyInto(this.DB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypeRegistry loadResource(String name) {
        InputStream clis = null;
        try {
            clis = SecuritySupport.getResourceAsStream(this.getClass(), name);
            if (clis != null) {
                MimeTypeRegistry mf = this.getImplementation().getByInputStream(clis);
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types file: " + name);
                }
                MimeTypeRegistry mimeTypeRegistry = mf;
                return mimeTypeRegistry;
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("MimetypesFileTypeMap: not loading mime types file: " + name);
            }
        }
        catch (IOException e) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MimetypesFileTypeMap: can't load " + name, e);
            }
        }
        catch (SecurityException sex) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MimetypesFileTypeMap: can't load " + name, sex);
            }
        }
        catch (NoSuchElementException | ServiceConfigurationError e) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("Cannot find or load an implementation for MimeTypeRegistryProvider.MimeTypeRegistry: can't load " + name, e);
            }
        }
        finally {
            block30: {
                try {
                    if (clis != null) {
                        clis.close();
                    }
                }
                catch (IOException ex) {
                    if (!LogSupport.isLoggable()) break block30;
                    LogSupport.log("InputStream cannot be close for " + name, ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(Vector<MimeTypeRegistry> v, String name) {
        boolean anyLoaded;
        block29: {
            anyLoaded = false;
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = SecuritySupport.getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                if ((urls = cld != null ? SecuritySupport.getResources(cld, name) : SecuritySupport.getSystemResources(name)) == null) break block29;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: getResources");
                }
                for (int i = 0; i < urls.length; ++i) {
                    URL url = urls[i];
                    InputStream clis = null;
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MimetypesFileTypeMap: URL " + url);
                    }
                    try {
                        clis = SecuritySupport.openStream(url);
                        if (clis != null) {
                            v.addElement(this.getImplementation().getByInputStream(clis));
                            anyLoaded = true;
                            if (!LogSupport.isLoggable()) continue;
                            LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types from URL: " + url);
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MimetypesFileTypeMap: not loading mime types from URL: " + url);
                        continue;
                    }
                    catch (IOException ioex) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MimetypesFileTypeMap: can't load " + url, ioex);
                        continue;
                    }
                    catch (SecurityException sex) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MimetypesFileTypeMap: can't load " + url, sex);
                        continue;
                    }
                    catch (NoSuchElementException | ServiceConfigurationError e) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("Cannot find or load an implementation for MimeTypeRegistryProvider.MimeTypeRegistry: can't load " + url, e);
                        continue;
                    }
                    finally {
                        block30: {
                            try {
                                if (clis != null) {
                                    clis.close();
                                }
                            }
                            catch (IOException cex) {
                                if (!LogSupport.isLoggable()) break block30;
                                LogSupport.log("InputStream cannot be close for " + name, cex);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!LogSupport.isLoggable()) break block29;
                LogSupport.log("MimetypesFileTypeMap: can't load " + name, ex);
            }
        }
        if (!anyLoaded) {
            LogSupport.log("MimetypesFileTypeMap: !anyLoaded");
            MimeTypeRegistry mf = this.loadResource("/" + name);
            if (mf != null) {
                v.addElement(mf);
            }
        }
    }

    private MimeTypeRegistry loadFile(String name) {
        MimeTypeRegistry mtf;
        block4: {
            mtf = null;
            try {
                mtf = this.getImplementation().getByFileName(name);
            }
            catch (IOException e) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimeTypeRegistry: can't load from file - " + name, e);
                }
            }
            catch (NoSuchElementException | ServiceConfigurationError e) {
                if (!LogSupport.isLoggable()) break block4;
                LogSupport.log("Cannot find or load an implementation for MimeTypeRegistryProvider.MimeTypeRegistry: can't load " + name, e);
            }
        }
        return mtf;
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        this();
        try {
            this.DB[0] = this.getImplementation().getByFileName(mimeTypeFileName);
        }
        catch (NoSuchElementException | ServiceConfigurationError e) {
            String errorMessage = "Cannot find or load an implementation for MimeTypeRegistryProvider.MimeTypeRegistry: can't load " + mimeTypeFileName;
            if (LogSupport.isLoggable()) {
                LogSupport.log(errorMessage, e);
            }
            throw new IOException(errorMessage, e);
        }
    }

    public MimetypesFileTypeMap(InputStream is) {
        block3: {
            this();
            try {
                this.DB[0] = this.getImplementation().getByInputStream(is);
            }
            catch (IOException iOException) {
            }
            catch (NoSuchElementException | ServiceConfigurationError e) {
                if (!LogSupport.isLoggable()) break block3;
                LogSupport.log("Cannot find or load an implementation for MimeTypeRegistryProvider.MimeTypeRegistry: can't load InputStream", e);
            }
        }
    }

    public synchronized void addMimeTypes(String mime_types) {
        try {
            if (this.DB[0] == null) {
                this.DB[0] = this.getImplementation().getInMemory();
            }
            this.DB[0].appendToRegistry(mime_types);
        }
        catch (NoSuchElementException | ServiceConfigurationError e) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("Cannot find or load an implementation for MimeTypeRegistryProvider.MimeTypeRegistry: can't add " + mime_types, e);
            }
            throw e;
        }
    }

    @Override
    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    @Override
    public synchronized String getContentType(String filename) {
        int dot_pos = filename.lastIndexOf(".");
        if (dot_pos < 0) {
            return defaultType;
        }
        String file_ext = filename.substring(dot_pos + 1);
        if (file_ext.length() == 0) {
            return defaultType;
        }
        for (int i = 0; i < this.DB.length; ++i) {
            String result;
            if (this.DB[i] == null || (result = this.DB[i].getMIMETypeString(file_ext)) == null) continue;
            return result;
        }
        return defaultType;
    }

    private MimeTypeRegistryProvider getImplementation() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<MimeTypeRegistryProvider>(){

                @Override
                public MimeTypeRegistryProvider run() {
                    return FactoryFinder.find(MimeTypeRegistryProvider.class, "com.sun.activation.registries.MimeTypeRegistryProviderImpl", false);
                }
            });
        }
        return FactoryFinder.find(MimeTypeRegistryProvider.class, "com.sun.activation.registries.MimeTypeRegistryProviderImpl", false);
    }

    static {
        String dir;
        block2: {
            dir = null;
            try {
                dir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String home = System.getProperty("java.home");
                        String newdir = home + File.separator + "conf";
                        File conf = new File(newdir);
                        if (conf.exists()) {
                            return newdir + File.separator;
                        }
                        return home + File.separator + "lib" + File.separator;
                    }
                });
            }
            catch (Exception ex) {
                if (!LogSupport.isLoggable()) break block2;
                LogSupport.log("Exception during MimetypesFileTypeMap class loading", ex);
            }
        }
        confDir = dir;
    }
}

