/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.BoundedThreadPoolConfiguration;
import org.infinispan.configuration.global.BoundedThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.CachedThreadPoolConfiguration;
import org.infinispan.configuration.global.CachedThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledThreadPoolConfiguration;
import org.infinispan.configuration.global.ScheduledThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.ThreadFactoryConfiguration;
import org.infinispan.configuration.global.ThreadFactoryConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.ThreadsConfiguration;

public class ThreadsConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<ThreadsConfiguration> {
    private final ThreadPoolConfigurationBuilder asyncThreadPool;
    private final ThreadPoolConfigurationBuilder expirationThreadPool;
    private final ThreadPoolConfigurationBuilder listenerThreadPool;
    private final ThreadPoolConfigurationBuilder persistenceThreadPool;
    private final ThreadPoolConfigurationBuilder remoteCommandThreadPool;
    private final ThreadPoolConfigurationBuilder stateTransferThreadPool;
    private final ThreadPoolConfigurationBuilder transportThreadPool;
    private final ThreadPoolConfigurationBuilder nonBlockingThreadPool;
    private final ThreadPoolConfigurationBuilder blockingThreadPool;
    private List<ThreadFactoryConfigurationBuilder> threadFactoryBuilders = new ArrayList<ThreadFactoryConfigurationBuilder>();
    private List<BoundedThreadPoolConfigurationBuilder> boundedThreadPoolBuilders = new ArrayList<BoundedThreadPoolConfigurationBuilder>();
    private List<ScheduledThreadPoolConfigurationBuilder> scheduledThreadPoolBuilders = new ArrayList<ScheduledThreadPoolConfigurationBuilder>();
    private List<CachedThreadPoolConfigurationBuilder> cachedThreadPoolBuilders = new ArrayList<CachedThreadPoolConfigurationBuilder>();
    private final Map<String, ThreadFactoryConfigurationBuilder> threadFactoryByName = new HashMap<String, ThreadFactoryConfigurationBuilder>();
    private final Map<String, ThreadPoolBuilderAdapter> threadPoolByName = new HashMap<String, ThreadPoolBuilderAdapter>();

    ThreadsConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.asyncThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.expirationThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.listenerThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.persistenceThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.stateTransferThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.remoteCommandThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.transportThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.nonBlockingThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.blockingThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public ThreadFactoryConfigurationBuilder addThreadFactory(String name) {
        ThreadFactoryConfigurationBuilder threadFactoryConfigurationBuilder = new ThreadFactoryConfigurationBuilder(this.getGlobalConfig(), name);
        this.threadFactoryBuilders.add(threadFactoryConfigurationBuilder);
        this.threadFactoryByName.put(name, threadFactoryConfigurationBuilder);
        return threadFactoryConfigurationBuilder;
    }

    public BoundedThreadPoolConfigurationBuilder addBoundedThreadPool(String name) {
        BoundedThreadPoolConfigurationBuilder configurationBuilder = new BoundedThreadPoolConfigurationBuilder(this.getGlobalConfig(), name);
        this.boundedThreadPoolBuilders.add(configurationBuilder);
        this.threadPoolByName.put(name, configurationBuilder);
        return configurationBuilder;
    }

    public ScheduledThreadPoolConfigurationBuilder addScheduledThreadPool(String name) {
        ScheduledThreadPoolConfigurationBuilder configurationBuilder = new ScheduledThreadPoolConfigurationBuilder(this.getGlobalConfig(), name);
        this.scheduledThreadPoolBuilders.add(configurationBuilder);
        this.threadPoolByName.put(name, configurationBuilder);
        return configurationBuilder;
    }

    public CachedThreadPoolConfigurationBuilder addCachedThreadPool(String name) {
        CachedThreadPoolConfigurationBuilder configurationBuilder = new CachedThreadPoolConfigurationBuilder(this.getGlobalConfig(), name);
        this.cachedThreadPoolBuilders.add(configurationBuilder);
        this.threadPoolByName.put(name, configurationBuilder);
        return configurationBuilder;
    }

    @Override
    public ThreadPoolConfigurationBuilder asyncThreadPool() {
        return this.asyncThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder expirationThreadPool() {
        return this.expirationThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder listenerThreadPool() {
        return this.listenerThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder persistenceThreadPool() {
        return this.persistenceThreadPool;
    }

    public ThreadPoolConfigurationBuilder remoteCommandThreadPool() {
        return this.remoteCommandThreadPool;
    }

    @Override
    @Deprecated
    public ThreadPoolConfigurationBuilder stateTransferThreadPool() {
        return this.stateTransferThreadPool;
    }

    @Deprecated
    public ThreadPoolConfigurationBuilder transportThreadPool() {
        return this.transportThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder nonBlockingThreadPool() {
        return this.nonBlockingThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder blockingThreadPool() {
        return this.blockingThreadPool;
    }

    public ThreadsConfigurationBuilder read(ThreadsConfiguration template) {
        this.asyncThreadPool.read(template.asyncThreadPool());
        this.expirationThreadPool.read(template.expirationThreadPool());
        this.listenerThreadPool.read(template.listenerThreadPool());
        this.persistenceThreadPool.read(template.persistenceThreadPool());
        this.remoteCommandThreadPool.read(template.remoteThreadPool());
        this.stateTransferThreadPool.read(template.stateTransferThreadPool());
        this.transportThreadPool.read(template.transportThreadPool());
        this.nonBlockingThreadPool.read(template.nonBlockingThreadPool());
        this.blockingThreadPool.read(template.blockingThreadPool());
        template.threadFactories().forEach(s -> this.threadFactoryBuilders.add(new ThreadFactoryConfigurationBuilder(this.getGlobalConfig(), (String)s.name().get()).read((ThreadFactoryConfiguration)s)));
        template.boundedThreadPools().forEach(s -> this.boundedThreadPoolBuilders.add(new BoundedThreadPoolConfigurationBuilder(this.getGlobalConfig(), s.name()).read((BoundedThreadPoolConfiguration)s)));
        template.cachedThreadPools().forEach(s -> this.cachedThreadPoolBuilders.add(new CachedThreadPoolConfigurationBuilder(this.getGlobalConfig(), s.name()).read((CachedThreadPoolConfiguration)s)));
        template.scheduledThreadPools().forEach(s -> this.scheduledThreadPoolBuilders.add(new ScheduledThreadPoolConfigurationBuilder(this.getGlobalConfig(), s.name()).read((ScheduledThreadPoolConfiguration)s)));
        return this;
    }

    public ThreadsConfiguration create() {
        List<ThreadFactoryConfiguration> threadFactoryConfigurations = this.threadFactoryBuilders.stream().map(ThreadFactoryConfigurationBuilder::create).collect(Collectors.toList());
        List<BoundedThreadPoolConfiguration> boundedThreadPoolConfigurations = this.boundedThreadPoolBuilders.stream().map(BoundedThreadPoolConfigurationBuilder::create).collect(Collectors.toList());
        List<ScheduledThreadPoolConfiguration> scheduledThreadPoolConfigurations = this.scheduledThreadPoolBuilders.stream().map(ScheduledThreadPoolConfigurationBuilder::create).collect(Collectors.toList());
        List<CachedThreadPoolConfiguration> cachedThreadPoolConfigurations = this.cachedThreadPoolBuilders.stream().map(CachedThreadPoolConfigurationBuilder::create).collect(Collectors.toList());
        return new ThreadsConfiguration(threadFactoryConfigurations, boundedThreadPoolConfigurations, cachedThreadPoolConfigurations, scheduledThreadPoolConfigurations, this.asyncThreadPool.create(), this.expirationThreadPool.create(), this.listenerThreadPool.create(), this.persistenceThreadPool.create(), this.remoteCommandThreadPool.create(), this.stateTransferThreadPool.create(), this.transportThreadPool.create(), this.nonBlockingThreadPool.create(), this.blockingThreadPool.create());
    }

    public ThreadsConfigurationBuilder nodeName(String value) {
        this.threadFactoryBuilders.forEach(tfb -> tfb.nodeName(value));
        return this;
    }

    public ThreadFactoryConfigurationBuilder getThreadFactory(String threadFactoryName) {
        return this.threadFactoryByName.get(threadFactoryName);
    }

    public ThreadPoolBuilderAdapter getThreadPool(String threadFactoryName) {
        return this.threadPoolByName.get(threadFactoryName);
    }
}

