/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.ClusterAffinityInterest;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptorInformation;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBProxyInformation;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.discovery.Discovery;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class EJBClientInvocationContext
extends AbstractInvocationContext {
    private static final Logs log = Logs.MAIN;
    public static final String PRIVATE_ATTACHMENTS_KEY = "org.jboss.ejb.client.invocation.attachments";
    public static final String RETURNED_CONTEXT_DATA_KEY = "jboss.returned.keys";
    private final EJBInvocationHandler<?> invocationHandler;
    private final Discovery discoveryContext;
    private final Object invokedProxy;
    private final Object[] parameters;
    private final EJBProxyInformation.ProxyMethodInfo methodInfo;
    private final EJBReceiverInvocationContext receiverInvocationContext = new EJBReceiverInvocationContext(this);
    private final EJBClientContext.InterceptorList interceptorList;
    private final long startTime = System.nanoTime();
    private long timeout;
    private final Object lock = new Object();
    private EJBReceiverInvocationContext.ResultProducer resultProducer;
    private volatile boolean cancelRequested;
    private boolean retryRequested;
    private State state = State.SENDING;
    private int remainingRetries;
    private Supplier<? extends Throwable> pendingFailure;
    private List<Supplier<? extends Throwable>> suppressedExceptions;
    private Object cachedResult;
    private int interceptorChainIndex;
    private boolean blockingCaller;
    private int waiters = 0;
    static final Supplier<Throwable> CANCELLED_PRODUCER = Logs.INVOCATION::requestCancelled;
    static final ThrowableResult CANCELLED = new ThrowableResult(CANCELLED_PRODUCER);
    static final ThrowableResult ONE_WAY = new ThrowableResult(Logs.INVOCATION::oneWayInvocation);

    EJBClientInvocationContext(EJBInvocationHandler<?> invocationHandler, EJBClientContext ejbClientContext, Object invokedProxy, Object[] parameters, EJBProxyInformation.ProxyMethodInfo methodInfo, int allowedRetries, Supplier<AuthenticationContext> authenticationContextSupplier, Discovery discoveryContext) {
        super(invocationHandler.getLocator(), ejbClientContext, authenticationContextSupplier != null ? authenticationContextSupplier.get() : AuthenticationContext.captureCurrent());
        this.invocationHandler = invocationHandler;
        this.discoveryContext = discoveryContext;
        this.invokedProxy = invokedProxy;
        this.parameters = parameters;
        this.methodInfo = methodInfo;
        long timeout = invocationHandler.getInvocationTimeout();
        if (timeout == -1L) {
            timeout = ejbClientContext.getInvocationTimeout();
        }
        this.timeout = timeout;
        this.remainingRetries = allowedRetries;
        this.interceptorList = this.getClientContext().getInterceptors(this.getViewClass(), this.getInvokedMethod());
    }

    public void addReturnedContextDataKey(String key) {
        HashSet returnedData = this.getContextData().get(RETURNED_CONTEXT_DATA_KEY);
        if (returnedData == null) {
            returnedData = new HashSet();
            this.getContextData().put(RETURNED_CONTEXT_DATA_KEY, returnedData);
        } else if (!(returnedData instanceof Set)) {
            throw Logs.INVOCATION.returnedContextDataKeyOfWrongType();
        }
        Set keys = returnedData;
        keys.add(key);
    }

    public <T> T getProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.getAttachment(key);
    }

    public <T> T removeProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.removeAttachment(key);
    }

    public boolean isClientAsync() {
        return this.invocationHandler.isAsyncHandler() || this.methodInfo.isClientAsync();
    }

    public boolean isSynchronous() {
        return !this.isClientAsync() && this.methodInfo.isSynchronous();
    }

    public boolean isIdempotent() {
        return this.methodInfo.isIdempotent();
    }

    public ClientTransactionPolicy getTransactionPolicy() {
        return this.methodInfo.getTransactionPolicy();
    }

    public boolean isCompressRequest() {
        if (this.methodInfo.getCompressRequestHint() == EJBProxyInformation.ProxyMethodInfo.CompressionHint.NONE) {
            return this.getClientContext().getDefaultCompression() != -1;
        }
        return this.methodInfo.getCompressRequestHint() == EJBProxyInformation.ProxyMethodInfo.CompressionHint.TRUE;
    }

    public boolean isCompressResponse() {
        if (this.methodInfo.getCompressResponseHint() == EJBProxyInformation.ProxyMethodInfo.CompressionHint.NONE) {
            return this.getClientContext().getDefaultCompression() != -1;
        }
        return this.methodInfo.getCompressResponseHint() == EJBProxyInformation.ProxyMethodInfo.CompressionHint.TRUE;
    }

    public int getCompressionLevel() {
        if (this.methodInfo.getCompressionLevel() != -1) {
            return this.methodInfo.getCompressionLevel();
        }
        return this.getClientContext().getDefaultCompression();
    }

    public String getMethodSignatureString() {
        return this.methodInfo.getSignature();
    }

    public EJBMethodLocator getMethodLocator() {
        return this.methodInfo.getMethodLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockingCaller() {
        Object object = this.lock;
        synchronized (object) {
            return this.blockingCaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockingCaller(boolean blockingCaller) {
        Object object = this.lock;
        synchronized (object) {
            this.blockingCaller = blockingCaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuppressed(Throwable cause) {
        Assert.checkNotNullParam("cause", cause);
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.DONE) {
                return;
            }
            if (this.suppressedExceptions == null) {
                this.suppressedExceptions = new ArrayList<Supplier<? extends Throwable>>();
            }
            this.suppressedExceptions.add(() -> cause);
            this.checkStateInvariants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuppressed(Supplier<? extends Throwable> cause) {
        Assert.checkNotNullParam("cause", cause);
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.DONE) {
                return;
            }
            if (this.suppressedExceptions == null) {
                this.suppressedExceptions = new ArrayList<Supplier<? extends Throwable>>();
            }
            this.suppressedExceptions.add(cause);
            this.checkStateInvariants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestRetry() {
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("Requesting retry of invocation!", new Object[0]);
        }
        Object object = this.lock;
        synchronized (object) {
            this.retryRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendRequestInitial() {
        assert (this.checkState() == State.SENDING);
        while (true) {
            assert (this.interceptorChainIndex == 0);
            try {
                this.getAuthenticationContext().runExConsumer(EJBClientInvocationContext::sendRequest, this);
                Object object = this.lock;
                synchronized (object) {
                    EJBReceiverInvocationContext.ResultProducer resultProducer;
                    block32: {
                        block33: {
                            assert (this.state == State.SENT || this.state == State.READY);
                            Supplier<? extends Throwable> pendingFailure = this.pendingFailure;
                            resultProducer = this.resultProducer;
                            if (pendingFailure == null) break block32;
                            if (resultProducer == null) {
                                this.resultProducer = new ThrowableResult(pendingFailure);
                            } else {
                                this.addSuppressed(pendingFailure);
                            }
                            this.pendingFailure = null;
                            this.transition(State.CONSUMING);
                            try {
                                this.getResult(true);
                            }
                            catch (Throwable t) {
                                if (this.state != State.SENDING) break block33;
                                this.checkStateInvariants();
                                continue;
                            }
                        }
                        this.checkStateInvariants();
                        return;
                    }
                    try {
                        if (resultProducer != null) {
                            this.transition(State.READY);
                            return;
                        }
                        this.transition(State.WAITING);
                        return;
                    }
                    finally {
                        this.checkStateInvariants();
                    }
                }
            }
            catch (Throwable t) {
                log.tracef("Encountered exception when calling sendRequestInitial: exception = %s)", (Object)t.getMessage());
                Object object = this.lock;
                synchronized (object) {
                    if (this.state == State.SENDING) {
                        this.transition(State.SENT);
                    }
                    assert (this.state == State.SENT || this.state == State.READY);
                    try {
                        Supplier<? extends Throwable> pendingFailure = this.pendingFailure;
                        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
                        if (resultProducer != null) {
                            if (pendingFailure != null) {
                                this.addSuppressed(t);
                                this.addSuppressed(pendingFailure);
                                this.pendingFailure = null;
                            }
                            this.transition(State.READY);
                            return;
                        }
                        if (!this.retryRequested || this.remainingRetries == 0) {
                            if (pendingFailure != null) {
                                this.addSuppressed(pendingFailure);
                            }
                            this.resultProducer = t instanceof Exception ? new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)t) : new EJBReceiverInvocationContext.ResultProducer.Failed(new UndeclaredThrowableException(t));
                            this.pendingFailure = null;
                            this.transition(State.READY);
                            return;
                        }
                        log.tracef("retrying the invocation!: remaining retries = %d", this.remainingRetries);
                        if (pendingFailure != null) {
                            this.addSuppressed(pendingFailure);
                        }
                        this.setReceiver(null);
                        this.pendingFailure = null;
                        this.transition(State.SENDING);
                        this.retryRequested = false;
                        --this.remainingRetries;
                    }
                    finally {
                        this.checkStateInvariants();
                    }
                }
                this.addSuppressed(t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State checkState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest() throws Exception {
        block43: {
            Object lock = this.lock;
            Assert.assertNotHoldsLock(lock);
            EJBClientInterceptorInformation[] chain = this.interceptorList.getInformation();
            Object object = lock;
            synchronized (object) {
                if (this.state != State.SENDING) {
                    throw Logs.MAIN.sendRequestCalledDuringWrongPhase();
                }
            }
            int idx = this.interceptorChainIndex++;
            try {
                if (this.cancelRequested) {
                    Object object2 = lock;
                    synchronized (object2) {
                        this.transition(State.SENT);
                        this.resultReady(CANCELLED);
                        this.checkStateInvariants();
                        break block43;
                    }
                }
                if (chain.length == idx) {
                    EJBReceiver receiver;
                    URI destination = this.getDestination();
                    try {
                        if (Logs.INVOCATION.isDebugEnabled()) {
                            Logs.INVOCATION.debugf("sendRequest: setting receiver, strong affinity = %s, weak affinity = %s, remote destination is: %s", (Object)this.getLocator().getAffinity(), (Object)this.invocationHandler.getWeakAffinity(), (Object)destination);
                        }
                        receiver = this.getClientContext().resolveReceiver(destination, this.getLocator());
                    }
                    catch (Throwable t) {
                        Object object3 = lock;
                        synchronized (object3) {
                            if (this.state != State.SENT) {
                                this.transition(State.SENT);
                            }
                            this.checkStateInvariants();
                        }
                        throw t;
                    }
                    this.setReceiver(receiver);
                    Object t = lock;
                    synchronized (t) {
                        this.transition(State.SENT);
                        this.checkStateInvariants();
                    }
                    try {
                        receiver.processInvocation(this.receiverInvocationContext);
                        break block43;
                    }
                    catch (Throwable t2) {
                        Object object4 = lock;
                        synchronized (object4) {
                            if (this.state != State.SENT) {
                                this.transition(State.SENT);
                            }
                            this.checkStateInvariants();
                        }
                        throw t2;
                    }
                }
                try {
                    if (Logs.INVOCATION.isDebugEnabled()) {
                        Logs.INVOCATION.debugf("sendRequest: calling interceptor: %s", (Object)chain[idx].getInterceptorInstance());
                    }
                    chain[idx].getInterceptorInstance().handleInvocation(this);
                }
                catch (Throwable t) {
                    Object object5 = lock;
                    synchronized (object5) {
                        if (this.state != State.SENT) {
                            this.transition(State.SENT);
                        }
                        this.checkStateInvariants();
                    }
                    throw t;
                }
                Object object6 = lock;
                synchronized (object6) {
                    try {
                        if (this.state != State.SENT && this.state != State.READY) {
                            assert (this.state == State.SENDING);
                            this.transition(State.SENT);
                            throw Logs.INVOCATION.requestNotSent();
                        }
                    }
                    finally {
                        this.checkStateInvariants();
                    }
                }
            }
            finally {
                --this.interceptorChainIndex;
            }
        }
    }

    public Object getResult() throws Exception {
        return this.getResult(false);
    }

    /*
     * Exception decompiling
     */
    Object getResult(boolean retry) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void discardResult() throws IllegalStateException {
        this.resultReady(ONE_WAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultReady(EJBReceiverInvocationContext.ResultProducer resultProducer) {
        Assert.checkNotNullParam("resultProducer", resultProducer);
        Object object = this.lock;
        synchronized (object) {
            if (this.state.isWaiting() && this.resultProducer == null) {
                this.resultProducer = resultProducer;
                if (this.state == State.WAITING || this.state == State.SENT) {
                    this.transition(State.READY);
                }
                this.checkStateInvariants();
                if (log.isTraceEnabled()) {
                    log.tracef("Result is ready for %s: result producer: %s, current state: %s", (Object)this, (Object)resultProducer, (Object)this.state);
                }
                return;
            }
            this.checkStateInvariants();
            if (log.isTraceEnabled()) {
                log.tracef("Result discarded for %s: result producer: %s, current state: %s", (Object)this, (Object)resultProducer, (Object)this.state);
            }
        }
        resultProducer.discardResult();
    }

    public Object getInvokedProxy() {
        return this.invokedProxy;
    }

    public Method getInvokedMethod() {
        return this.methodInfo.getMethod();
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public long getRemainingInvocationTime(TimeUnit timeUnit) {
        Assert.checkNotNullParam("timeUnit", timeUnit);
        long timeout = this.timeout;
        if (timeout <= 0L) {
            return Long.MAX_VALUE;
        }
        return Math.max(0L, timeUnit.convert(timeout - (System.nanoTime() - this.startTime) / 1000000L, TimeUnit.MILLISECONDS));
    }

    @Override
    public <T> void setLocator(EJBLocator<T> locator) {
        ClusterAffinityInterest interest;
        super.setLocator(locator);
        Affinity affinity = locator.getAffinity();
        if (affinity instanceof ClusterAffinity && (interest = this.invocationHandler.getAttachment(ClusterAffinityInterest.KEY)) != null) {
            interest.notifyAssignment((ClusterAffinity)affinity);
        }
    }

    @NotNull
    Discovery getDiscovery() {
        return this.discoveryContext;
    }

    Future<?> getFutureResponse() {
        return new FutureResponse();
    }

    void proceedAsynchronously() {
        if (this.getInvokedMethod().getReturnType() == Void.TYPE) {
            this.resultReady(EJBReceiverInvocationContext.ResultProducer.NULL);
        }
    }

    private void transition(State newState) {
        Object lock = this.lock;
        Assert.assertHoldsLock(lock);
        State oldState = this.state;
        if (oldState == newState) {
            return;
        }
        if (log.isTraceEnabled()) {
            StackTraceElement caller = new Exception().getStackTrace()[1];
            log.tracef("Transitioning %s from %s to %s (%s)", new Object[]{this, oldState, newState, caller});
        }
        switch (oldState) {
            case SENDING: {
                assert (newState == State.SENT);
                break;
            }
            case SENT: {
                assert (newState == State.READY || newState == State.SENDING || newState == State.DONE || newState == State.WAITING || newState == State.CONSUMING);
                break;
            }
            case WAITING: {
                assert (newState == State.DONE || newState == State.READY || newState == State.CONSUMING);
                break;
            }
            case READY: {
                assert (newState == State.CONSUMING);
                break;
            }
            case CONSUMING: {
                assert (newState == State.SENDING || newState == State.DONE || newState == State.READY);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        switch (newState) {
            case READY: 
            case DONE: {
                this.remainingRetries = 0;
            }
            case WAITING: {
                if (this.waiters <= 0) break;
                lock.notifyAll();
            }
        }
        this.state = newState;
    }

    private void checkStateInvariants() {
        Object lock = this.lock;
        Assert.assertHoldsLock(lock);
        State state = this.state;
        switch (state) {
            case SENDING: {
                assert (this.resultProducer == null && this.cachedResult == null && this.getReceiver() == null);
                break;
            }
            case SENT: {
                assert (this.cachedResult == null);
                break;
            }
            case WAITING: {
                assert (this.resultProducer == null && this.pendingFailure == null && this.cachedResult == null);
                break;
            }
            case READY: {
                assert (this.resultProducer != null && this.pendingFailure == null && this.cachedResult == null && this.remainingRetries == 0);
                break;
            }
            case CONSUMING: {
                assert (this.resultProducer != null && this.pendingFailure == null && this.cachedResult == null);
                break;
            }
            case DONE: {
                assert (this.resultProducer == null && (this.pendingFailure == null || this.pendingFailure != null && this.cachedResult == null) && this.remainingRetries == 0);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitCancellationResult() {
        Object lock = this.lock;
        Assert.assertNotHoldsLock(lock);
        Object object = lock;
        synchronized (object) {
            while (this.resultProducer != CANCELLED) {
                if (!this.state.isWaiting()) {
                    return false;
                }
                try {
                    this.checkStateInvariants();
                    try {
                        ++this.waiters;
                        lock.wait();
                    }
                    finally {
                        --this.waiters;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object awaitResponse() throws Exception {
        Assert.assertNotHoldsLock(this.lock);
        intr = false;
        timedOut = false;
        try {
            block36: {
                lock = this.lock;
                timeout = this.timeout;
                var6_5 = lock;
                synchronized (var6_5) {
                    try {
                        block29: while (true) {
                            switch (1.$SwitchMap$org$jboss$ejb$client$EJBClientInvocationContext$State[this.state.ordinal()]) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 5: {
                                    if (timeout <= 0L || timedOut) {
                                        try {
                                            this.checkStateInvariants();
                                            try {
                                                ++this.waiters;
                                                lock.wait();
                                            }
                                            finally {
                                                --this.waiters;
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            intr = true;
                                        }
                                        continue block29;
                                    }
                                    remaining = Math.max(0L, timeout * 1000000L - Math.max(0L, System.nanoTime() - this.startTime));
                                    if (remaining == 0L) {
                                        timedOut = true;
                                        this.timeout = 0L;
                                        if (this.state == State.CONSUMING) {
                                            this.addSuppressed(new TimeoutException("No invocation response received in " + timeout + " milliseconds"));
                                            this.transition(State.READY);
                                            continue block29;
                                        }
                                        this.resultReady(new ThrowableResult((Supplier<Throwable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$awaitResponse$3(long ), ()Ljava/lang/Throwable;)((long)timeout)));
                                        continue block29;
                                    }
                                    try {
                                        this.checkStateInvariants();
                                        try {
                                            ++this.waiters;
                                            lock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                                            continue block29;
                                        }
                                        finally {
                                            --this.waiters;
                                            continue block29;
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        intr = true;
                                        continue block29;
                                    }
                                }
                                case 4: {
                                    this.checkStateInvariants();
                                    ** break;
lbl52:
                                    // 1 sources

                                    break block36;
                                }
                                case 6: {
                                    this.checkStateInvariants();
                                    if (this.pendingFailure == null) {
                                        t = this.cachedResult;
                                        return t;
                                    }
                                    try {
                                        throw this.pendingFailure.get();
                                    }
                                    catch (Error | Exception e) {
                                        throw e;
                                    }
                                    catch (Throwable t) {
                                        throw new UndeclaredThrowableException(t);
                                    }
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                            break;
                        }
                    }
                    finally {
                        this.blockingCaller = false;
                    }
                }
            }
            var6_5 = this.getResult();
            return var6_5;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
            if (timedOut && (receiver = this.getReceiver()) != null) {
                receiver.cancelInvocation(this.receiverInvocationContext, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDiscardResult() {
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        Object lock = this.lock;
        assert (!Thread.holdsLock(lock));
        Object object = lock;
        synchronized (object) {
            resultProducer = this.resultProducer;
            this.resultProducer = EJBReceiverInvocationContext.ResultProducer.NULL;
            if (this.state == State.WAITING) {
                this.transition(State.DONE);
            }
            this.checkStateInvariants();
        }
        if (resultProducer != null) {
            resultProducer.discardResult();
        }
    }

    void cancelled() {
        this.resultReady(CANCELLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Exception exception, Executor retryExecutor) {
        Object lock;
        Object object = lock = this.lock;
        synchronized (object) {
            log.tracef("Invocation marked failed, state is currently: %s", (Object)this.state);
            switch (this.state) {
                case CONSUMING: 
                case DONE: {
                    return;
                }
                case SENDING: {
                    throw new IllegalStateException();
                }
                case SENT: {
                    Supplier<? extends Throwable> pendingFailure = this.pendingFailure;
                    if (pendingFailure != null) {
                        this.addSuppressed(pendingFailure);
                    }
                    this.pendingFailure = () -> exception;
                    return;
                }
                case READY: {
                    this.addSuppressed(exception);
                    return;
                }
                case WAITING: {
                    this.resultProducer = new ThrowableResult(() -> exception);
                    this.pendingFailure = null;
                    this.transition(State.CONSUMING);
                    this.checkStateInvariants();
                    break;
                }
                default: {
                    throw Assert.impossibleSwitchCase((Object)this.state);
                }
            }
        }
        retryExecutor.execute(this::retryOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retryOperation() {
        block5: {
            try {
                this.getResult(true);
            }
            catch (Throwable t) {
                boolean retry;
                Object object = this.lock;
                synchronized (object) {
                    retry = this.state == State.SENDING;
                }
                if (!retry) break block5;
                this.sendRequestInitial();
            }
        }
    }

    private static /* synthetic */ Throwable lambda$awaitResponse$3(long timeout) {
        return new TimeoutException("No invocation response received in " + timeout + " milliseconds");
    }

    private static /* synthetic */ Throwable lambda$getResult$2(Throwable t) {
        return t;
    }

    private static /* synthetic */ Throwable lambda$getResult$1(Throwable t) {
        return t;
    }

    static enum State {
        SENDING(true),
        SENT(true),
        WAITING(true),
        READY(false),
        CONSUMING(false),
        DONE(false);

        private final boolean waiting;

        private State(boolean waiting) {
            this.waiting = waiting;
        }

        boolean isWaiting() {
            return this.waiting;
        }
    }

    static final class ThrowableResult
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Supplier<? extends Throwable> pendingFailure;

        ThrowableResult(Supplier<? extends Throwable> pendingFailure) {
            this.pendingFailure = pendingFailure;
        }

        @Override
        public Object getResult() throws Exception {
            try {
                throw this.pendingFailure.get();
            }
            catch (Error | Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }

        @Override
        public void discardResult() {
        }
    }

    final class FutureResponse
    implements Future<Object> {
        FutureResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result;
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            Object object = lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state == State.DONE) {
                    return EJBClientInvocationContext.this.pendingFailure == CANCELLED_PRODUCER;
                }
                if (!EJBClientInvocationContext.this.state.isWaiting()) {
                    return EJBClientInvocationContext.this.resultProducer == CANCELLED;
                }
                if (EJBClientInvocationContext.this.resultProducer == CANCELLED) {
                    return true;
                }
                EJBClientInvocationContext.this.cancelRequested = true;
            }
            EJBReceiver receiver = EJBClientInvocationContext.this.getReceiver();
            boolean bl = result = receiver != null && receiver.cancelInvocation(EJBClientInvocationContext.this.receiverInvocationContext, mayInterruptIfRunning);
            if (!result) {
                Object object2 = lock;
                synchronized (object2) {
                    if (EJBClientInvocationContext.this.resultProducer == CANCELLED || EJBClientInvocationContext.this.state == State.DONE && EJBClientInvocationContext.this.pendingFailure == CANCELLED_PRODUCER) {
                        return true;
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            Object object = lock;
            synchronized (object) {
                return EJBClientInvocationContext.this.state == State.DONE ? EJBClientInvocationContext.this.pendingFailure == CANCELLED_PRODUCER : EJBClientInvocationContext.this.resultProducer == CANCELLED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            Object object = lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state == State.CONSUMING) {
                    return EJBClientInvocationContext.this.retryRequested && EJBClientInvocationContext.this.remainingRetries > 0 && EJBClientInvocationContext.this.resultProducer instanceof ThrowableResult;
                }
                return !EJBClientInvocationContext.this.state.isWaiting();
            }
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            try {
                return EJBClientInvocationContext.this.awaitResponse();
            }
            catch (InterruptedException | ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw log.remoteInvFailed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long ourStart;
            Object lock = EJBClientInvocationContext.this.lock;
            assert (!Thread.holdsLock(lock));
            long handlerInvTimeout = EJBClientInvocationContext.this.invocationHandler.getInvocationTimeout();
            long invocationTimeout = handlerInvTimeout != -1L ? handlerInvTimeout : EJBClientInvocationContext.this.getClientContext().getInvocationTimeout();
            if (unit.convert(Math.max(0L, invocationTimeout * 1000000L - Math.max(0L, (ourStart = System.nanoTime()) - EJBClientInvocationContext.this.startTime)), TimeUnit.NANOSECONDS) <= timeout) {
                return this.get();
            }
            long remaining = unit.toNanos(timeout);
            Object object = lock;
            synchronized (object) {
                block14: while (true) {
                    switch (EJBClientInvocationContext.this.state) {
                        case SENDING: 
                        case SENT: 
                        case WAITING: 
                        case CONSUMING: {
                            EJBClientInvocationContext.this.checkStateInvariants();
                            if (remaining <= 0L) {
                                throw log.timedOut();
                            }
                            try {
                                EJBClientInvocationContext.this.waiters++;
                                lock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                            }
                            finally {
                                EJBClientInvocationContext.this.waiters--;
                            }
                            remaining = unit.toNanos(timeout) - (System.nanoTime() - ourStart);
                            continue block14;
                        }
                        case READY: {
                            EJBClientInvocationContext.this.checkStateInvariants();
                            break block14;
                        }
                        case DONE: {
                            EJBClientInvocationContext.this.checkStateInvariants();
                            if (EJBClientInvocationContext.this.pendingFailure != null) {
                                throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.pendingFailure.get());
                            }
                            return EJBClientInvocationContext.this.cachedResult;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break;
                }
            }
            try {
                return EJBClientInvocationContext.this.getResult();
            }
            catch (InterruptedException | ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw log.remoteInvFailed(e);
            }
        }
    }
}

