/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.api.monitoring;

import java.util.Stack;
import org.jboss.ws.api.Log;

public class RecordGroupAssociation {
    private static ThreadLocal<Stack<String>> groupIDAssoc = new ThreadLocal();

    public static void pushGroupID(String groupID) {
        Stack<String> stack;
        if (Log.LOGGER.isTraceEnabled()) {
            Log.LOGGER.pushGroupID(groupID, Thread.currentThread().getName());
        }
        if ((stack = groupIDAssoc.get()) == null) {
            stack = new Stack();
            groupIDAssoc.set(stack);
        }
        stack.push(groupID);
    }

    public static String peekGroupID() {
        String groupID = null;
        Stack<String> stack = groupIDAssoc.get();
        if (stack != null && !stack.isEmpty()) {
            groupID = stack.peek();
        }
        if (Log.LOGGER.isTraceEnabled()) {
            Log.LOGGER.peekGroupID(groupID, Thread.currentThread().getName());
        }
        return groupID;
    }

    public static String popGroupID() {
        String groupID = null;
        Stack<String> stack = groupIDAssoc.get();
        if (stack != null && !stack.isEmpty()) {
            groupID = stack.pop();
        }
        if (Log.LOGGER.isTraceEnabled()) {
            Log.LOGGER.popGroupID(groupID, Thread.currentThread().getName());
        }
        return groupID;
    }
}

