/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security;

import java.util.function.UnaryOperator;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.server.security.VirtualDomainMetaData;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public class VirtualDomainUtil {
    public static VirtualDomainMetaData configureVirtualDomain(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, SecurityDomain.Builder virtualDomainBuilder) throws DeploymentUnitProcessingException {
        UnaryOperator<SecurityIdentity> securityIdentityTransformer;
        VirtualDomainMetaData virtualDomainMetaData = VirtualDomainUtil.getVirtualDomainMetaData(phaseContext, deploymentUnit);
        if (virtualDomainMetaData != null && (securityIdentityTransformer = virtualDomainMetaData.getSecurityIdentityTransformer()) != null) {
            virtualDomainBuilder.setSecurityIdentityTransformer(securityIdentityTransformer);
        }
        return virtualDomainMetaData;
    }

    public static void setTopLevelDeploymentSecurityMetaData(DeploymentUnit deploymentUnit, ServiceName virtualDomainName) {
        DeploymentUnit topLevelDeployment = VirtualDomainUtil.toRoot(deploymentUnit);
        SecurityMetaData topLevelSecurityMetaData = topLevelDeployment.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
        topLevelSecurityMetaData.setSecurityDomain(virtualDomainName);
    }

    private static <T> ServiceController<T> getService(ServiceRegistry serviceRegistry, ServiceName serviceName, Class<T> serviceType) {
        ServiceController controller = serviceRegistry.getService(serviceName);
        return controller;
    }

    private static VirtualDomainMetaData getVirtualDomainMetaData(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        ServiceName virtualDomainMetaDataName = VirtualDomainMarkerUtility.virtualDomainMetaDataName(phaseContext, deploymentUnit);
        ServiceController<VirtualDomainMetaData> serviceContainer = VirtualDomainUtil.getService(phaseContext.getServiceRegistry(), virtualDomainMetaDataName, VirtualDomainMetaData.class);
        if (serviceContainer != null) {
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ServerLogger.ROOT_LOGGER.requiredServiceNotUp(virtualDomainMetaDataName, serviceState);
            }
            return (VirtualDomainMetaData)serviceContainer.getService().getValue();
        }
        return null;
    }

    private static DeploymentUnit toRoot(DeploymentUnit deploymentUnit) {
        DeploymentUnit result = deploymentUnit;
        DeploymentUnit parent = result.getParent();
        while (parent != null) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }
}

