/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCommitDeleteEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.spi.StatisticsImplementor;

public class EntityDeleteAction
extends EntityAction {
    private final Object version;
    private final boolean isCascadeDeleteEnabled;
    private final Object[] state;
    private SoftLock lock;
    private Object naturalIdValues;

    public EntityDeleteAction(Object id, Object[] state, Object version, Object instance, EntityPersister persister, boolean isCascadeDeleteEnabled, EventSource session) {
        super(session, id, instance, persister);
        this.version = version;
        this.isCascadeDeleteEnabled = isCascadeDeleteEnabled;
        this.state = state;
        NaturalIdMapping naturalIdMapping = persister.getNaturalIdMapping();
        if (naturalIdMapping != null) {
            this.naturalIdValues = session.getPersistenceContextInternal().getNaturalIdResolutions().removeLocalResolution(this.getId(), naturalIdMapping.extractNaturalIdFromEntityState(state), this.getPersister());
        }
    }

    public EntityDeleteAction(Object id, EntityPersister persister, EventSource session) {
        super(session, id, null, persister);
        this.version = null;
        this.isCascadeDeleteEnabled = false;
        this.state = null;
    }

    public Object getVersion() {
        return this.version;
    }

    public boolean isCascadeDeleteEnabled() {
        return this.isCascadeDeleteEnabled;
    }

    public Object[] getState() {
        return this.state;
    }

    protected Object getNaturalIdValues() {
        return this.naturalIdValues;
    }

    protected SoftLock getLock() {
        return this.lock;
    }

    protected void setLock(SoftLock lock) {
        this.lock = lock;
    }

    private boolean isInstanceLoaded() {
        return this.getInstance() != null;
    }

    @Override
    public void execute() throws HibernateException {
        Object id = this.getId();
        Object version = this.getCurrentVersion();
        EntityPersister persister = this.getPersister();
        EventSource session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.isInstanceLoaded() && this.preDelete();
        Object ck = this.lockCacheItem();
        if (!this.isCascadeDeleteEnabled && !veto) {
            persister.delete(id, version, instance, session);
        }
        if (this.isInstanceLoaded()) {
            this.postDeleteLoaded(id, persister, session, instance, ck);
        } else {
            this.postDeleteUnloaded(id, persister, session, ck);
        }
        StatisticsImplementor statistics = this.getSession().getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !veto) {
            statistics.deleteEntity(this.getPersister().getEntityName());
        }
    }

    private Object getCurrentVersion() {
        return this.getPersister().isVersionPropertyGenerated() && this.isInstanceLoaded() ? this.getPersister().getVersion(this.getInstance()) : this.version;
    }

    private void postDeleteLoaded(Object id, EntityPersister persister, SharedSessionContractImplementor session, Object instance, Object ck) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.removeEntry(instance);
        if (entry == null) {
            throw new AssertionFailure("possible non-threadsafe access to session");
        }
        entry.postDelete();
        EntityKey key = entry.getEntityKey();
        persistenceContext.removeEntity(key);
        persistenceContext.removeProxy(key);
        this.removeCacheItem(ck);
        persistenceContext.getNaturalIdResolutions().removeSharedResolution(id, this.naturalIdValues, persister);
        this.postDelete();
    }

    private void postDeleteUnloaded(Object id, EntityPersister persister, SharedSessionContractImplementor session, Object ck) {
        EntityKey key;
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (!persistenceContext.containsDeletedUnloadedEntityKey(key = session.generateEntityKey(id, persister))) {
            throw new AssertionFailure("deleted proxy should be for an unloaded entity: " + key);
        }
        persistenceContext.removeProxy(key);
        this.removeCacheItem(ck);
    }

    protected boolean preDelete() {
        EventListenerGroup<PreDeleteEventListener> listenerGroup = this.getFastSessionServices().eventListenerGroup_PRE_DELETE;
        if (listenerGroup.isEmpty()) {
            return false;
        }
        PreDeleteEvent event = new PreDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
        boolean veto = false;
        for (PreDeleteEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreDelete(event);
        }
        return veto;
    }

    protected void postDelete() {
        this.getFastSessionServices().eventListenerGroup_POST_DELETE.fireLazyEventOnEachListener(this::newPostDeleteEvent, PostDeleteEventListener::onPostDelete);
    }

    PostDeleteEvent newPostDeleteEvent() {
        return new PostDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
    }

    protected void postCommitDelete(boolean success) {
        EventListenerGroup<PostDeleteEventListener> eventListeners = this.getFastSessionServices().eventListenerGroup_POST_COMMIT_DELETE;
        if (success) {
            eventListeners.fireLazyEventOnEachListener(this::newPostDeleteEvent, PostDeleteEventListener::onPostDelete);
        } else {
            eventListeners.fireLazyEventOnEachListener(this::newPostDeleteEvent, EntityDeleteAction::postCommitDeleteOnUnsuccessful);
        }
    }

    private static void postCommitDeleteOnUnsuccessful(PostDeleteEventListener listener, PostDeleteEvent event) {
        if (listener instanceof PostCommitDeleteEventListener) {
            ((PostCommitDeleteEventListener)listener).onPostDeleteCommitFailed(event);
        } else {
            listener.onPostDelete(event);
        }
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws HibernateException {
        this.unlockCacheItem();
        this.postCommitDelete(success);
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        for (PostDeleteEventListener listener : this.getFastSessionServices().eventListenerGroup_POST_COMMIT_DELETE.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    private Object lockCacheItem() {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            EventSource session = this.getSession();
            Object ck = cache.generateCacheKey(this.getId(), persister, session.getFactory(), session.getTenantIdentifier());
            this.lock = cache.lockItem(session, ck, this.getCurrentVersion());
            return ck;
        }
        return null;
    }

    private void unlockCacheItem() {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            EventSource session = this.getSession();
            Object ck = cache.generateCacheKey(this.getId(), persister, session.getFactory(), session.getTenantIdentifier());
            cache.unlockItem(session, ck, this.lock);
        }
    }

    private void removeCacheItem(Object ck) {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            persister.getCacheAccessStrategy().remove(this.getSession(), ck);
        }
    }
}

