/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromUrl;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputNonExistentImpl;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaTruncator;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class SchemaTruncatorImpl
implements SchemaTruncator {
    private static final Logger log = Logger.getLogger(SchemaTruncatorImpl.class);
    private final HibernateSchemaManagementTool tool;

    public SchemaTruncatorImpl(HibernateSchemaManagementTool tool, SchemaFilter truncatorFilter) {
        this.tool = tool;
    }

    @Override
    public void doTruncate(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, TargetDescriptor targetDescriptor) {
        JdbcContext jdbcContext = this.tool.resolveJdbcContext(options.getConfigurationValues());
        GenerationTarget[] targets = this.tool.buildGenerationTargets(targetDescriptor, jdbcContext, options.getConfigurationValues(), true);
        this.doTruncate(metadata, options, contributableInclusionFilter, jdbcContext.getDialect(), targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTruncate(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, Dialect dialect, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performTruncate(metadata, options, contributableInclusionFilter, dialect, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                }
            }
        }
    }

    private void performTruncate(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, Dialect dialect, GenerationTarget ... targets) {
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        this.truncateFromMetadata(metadata, options, contributableInclusionFilter, dialect, formatter, targets);
    }

    private void truncateFromMetadata(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        Database database = metadata.getDatabase();
        SqlStringGenerationContext context = SqlStringGenerationContextImpl.fromConfigurationMap(metadata.getDatabase().getJdbcEnvironment(), database, options.getConfigurationValues());
        HashSet<String> exportIdentifiers = CollectionHelper.setOfSize(50);
        for (Namespace namespace : database.getNamespaces()) {
            if (!options.getSchemaFilter().includeNamespace(namespace)) continue;
            this.disableConstraints(namespace, metadata, formatter, options, context, contributableInclusionFilter, targets);
            SchemaTruncatorImpl.applySqlString(dialect.getTableCleaner().getSqlBeforeString(), formatter, options, targets);
            ArrayList<Table> list = new ArrayList<Table>(namespace.getTables().size());
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable() || !options.getSchemaFilter().includeTable(table) || !contributableInclusionFilter.matches(table)) continue;
                SchemaTruncatorImpl.checkExportIdentifier(table, exportIdentifiers);
                list.add(table);
            }
            SchemaTruncatorImpl.applySqlStrings(dialect.getTableCleaner().getSqlTruncateStrings(list, metadata, context), formatter, options, targets);
            SchemaTruncatorImpl.applySqlString(dialect.getTableCleaner().getSqlAfterString(), formatter, options, targets);
            this.enableConstraints(namespace, metadata, formatter, options, context, contributableInclusionFilter, targets);
        }
        SqlScriptCommandExtractor commandExtractor = this.tool.getServiceRegistry().getService(SqlScriptCommandExtractor.class);
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        this.applyImportSources(options, commandExtractor, format, dialect, targets);
    }

    private void disableConstraints(Namespace namespace, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext context, ContributableMatcher contributableInclusionFilter, GenerationTarget ... targets) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !options.getSchemaFilter().includeTable(table) || !contributableInclusionFilter.matches(table)) continue;
            for (ForeignKey foreignKey : table.getForeignKeys().values()) {
                if (dialect.canDisableConstraints()) {
                    SchemaTruncatorImpl.applySqlString(dialect.getTableCleaner().getSqlDisableConstraintString(foreignKey, metadata, context), formatter, options, targets);
                    continue;
                }
                if (dialect.canBatchTruncate()) continue;
                SchemaTruncatorImpl.applySqlStrings(dialect.getForeignKeyExporter().getSqlDropStrings(foreignKey, metadata, context), formatter, options, targets);
            }
        }
    }

    private void enableConstraints(Namespace namespace, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext context, ContributableMatcher contributableInclusionFilter, GenerationTarget ... targets) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !options.getSchemaFilter().includeTable(table) || !contributableInclusionFilter.matches(table)) continue;
            for (ForeignKey foreignKey : table.getForeignKeys().values()) {
                if (dialect.canDisableConstraints()) {
                    SchemaTruncatorImpl.applySqlString(dialect.getTableCleaner().getSqlEnableConstraintString(foreignKey, metadata, context), formatter, options, targets);
                    continue;
                }
                if (dialect.canBatchTruncate()) continue;
                SchemaTruncatorImpl.applySqlStrings(dialect.getForeignKeyExporter().getSqlCreateStrings(foreignKey, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings == null) {
            return;
        }
        for (String sqlString : sqlStrings) {
            SchemaTruncatorImpl.applySqlString(sqlString, formatter, options, targets);
        }
    }

    private static void applySqlString(String sqlString, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (StringHelper.isEmpty(sqlString)) {
            return;
        }
        String sqlStringFormatted = formatter.format(sqlString);
        for (GenerationTarget target : targets) {
            try {
                target.accept(sqlStringFormatted);
            }
            catch (CommandAcceptanceException e) {
                options.getExceptionHandler().handleException(e);
            }
        }
    }

    private void applyImportSources(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, boolean format, Dialect dialect, GenerationTarget ... targets) {
        ServiceRegistry serviceRegistry = this.tool.getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        Formatter formatter = FormatStyle.NONE.getFormatter();
        Object importScriptSetting = options.getConfigurationValues().get("javax.persistence.sql-load-script-source");
        if (importScriptSetting == null) {
            importScriptSetting = options.getConfigurationValues().get("jakarta.persistence.sql-load-script-source");
        }
        String charsetName = (String)options.getConfigurationValues().get("hibernate.hbm2ddl.charset_name");
        if (importScriptSetting != null) {
            ScriptSourceInput importScriptInput = Helper.interpretScriptSourceSetting(importScriptSetting, classLoaderService, charsetName);
            List<String> commands = importScriptInput.extract(reader -> commandExtractor.extractCommands((Reader)reader, dialect));
            for (int i = 0; i < commands.size(); ++i) {
                SchemaTruncatorImpl.applySqlString(commands.get(i), formatter, options, targets);
            }
        }
        String importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", options.getConfigurationValues(), "/import.sql");
        for (String currentFile : importFiles.split(",")) {
            String resourceName = currentFile.trim();
            if (resourceName.isEmpty()) continue;
            ScriptSourceInput importScriptInput = this.interpretLegacyImportScriptSetting(resourceName, classLoaderService, charsetName);
            List<String> commands = importScriptInput.extract(reader -> commandExtractor.extractCommands((Reader)reader, dialect));
            for (int i = 0; i < commands.size(); ++i) {
                SchemaTruncatorImpl.applySqlString(commands.get(i), formatter, options, targets);
            }
        }
    }

    private ScriptSourceInput interpretLegacyImportScriptSetting(String resourceName, ClassLoaderService classLoaderService, String charsetName) {
        try {
            URL resourceUrl = classLoaderService.locateResource(resourceName);
            if (resourceUrl == null) {
                return ScriptSourceInputNonExistentImpl.INSTANCE;
            }
            return new ScriptSourceInputFromUrl(resourceUrl, charsetName);
        }
        catch (Exception e) {
            throw new SchemaManagementException("Error resolving legacy import resource : " + resourceName, e);
        }
    }
}

