/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;
import org.hibernate.service.ServiceRegistry;
import org.jboss.jandex.IndexView;

public class HibernateSearchCompositeMappingProducer
implements AdditionalJaxbMappingProducer {
    @SuppressForbiddenApis(reason="Strangely, this SPI involves the internal MappingBinder class, and there's nothing we can do about it")
    public Collection<MappingDocument> produceAdditionalMappings(MetadataImplementor metadata, IndexView jandexIndex, MappingBinder mappingBinder, MetadataBuildingContext buildingContext) {
        Optional<HibernateSearchPreIntegrationService> preIntegrationServiceOptional = HibernateOrmUtils.getServiceOrEmpty((ServiceRegistry)buildingContext.getBootstrapContext().getServiceRegistry(), HibernateSearchPreIntegrationService.class);
        if (!preIntegrationServiceOptional.isPresent()) {
            return Collections.emptyList();
        }
        HibernateSearchPreIntegrationService preIntegrationService = preIntegrationServiceOptional.get();
        ArrayList<MappingDocument> mappings = new ArrayList<MappingDocument>();
        ConfigurationPropertySource propertySource = preIntegrationService.propertySource().withMask("hibernate.search").withMask("coordination");
        for (HibernateSearchOrmMappingProducer mappingProducer : preIntegrationService.coordinationStrategyConfiguration().mappingProducers()) {
            mappings.addAll(mappingProducer.produceMappings(propertySource, mappingBinder, buildingContext));
        }
        return mappings;
    }
}

