/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.mechanisms.openid.OpenIdState;
import org.glassfish.soteria.mechanisms.openid.controller.NonceController;
import org.glassfish.soteria.mechanisms.openid.controller.StateController;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdNonce;
import org.glassfish.soteria.servlet.HttpStorageController;
import org.glassfish.soteria.servlet.RequestData;

@ApplicationScoped
public class AuthenticationController {
    @Inject
    private StateController stateController;
    @Inject
    private NonceController nonceController;
    @Inject
    private OpenIdConfiguration configuration;
    private static final Logger LOGGER = Logger.getLogger(AuthenticationController.class.getName());

    public AuthenticationStatus authenticateUser(HttpServletRequest request, HttpServletResponse response) {
        UriBuilder authRequest = UriBuilder.fromUri((String)this.configuration.getProviderMetadata().getAuthorizationEndpoint()).queryParam("scope", new Object[]{this.configuration.getScopes()}).queryParam("response_type", new Object[]{this.configuration.getResponseType()}).queryParam("client_id", new Object[]{this.configuration.getClientId()}).queryParam("redirect_uri", new Object[]{this.configuration.buildRedirectURI(request)});
        OpenIdState state = new OpenIdState();
        authRequest.queryParam("state", new Object[]{state.getValue()});
        this.stateController.store(state, this.configuration, request, response);
        this.storeRequestURL(request, response);
        if (this.configuration.isUseNonce()) {
            OpenIdNonce nonce = new OpenIdNonce();
            String nonceHash = this.nonceController.getNonceHash(nonce);
            authRequest.queryParam("nonce", new Object[]{nonceHash});
            this.nonceController.store(nonce, this.configuration, request, response);
        }
        if (!Utils.isEmpty(this.configuration.getResponseMode())) {
            authRequest.queryParam("response_mode", new Object[]{this.configuration.getResponseMode()});
        }
        if (!Utils.isEmpty(this.configuration.getDisplay())) {
            authRequest.queryParam("display", new Object[]{this.configuration.getDisplay()});
        }
        if (!Utils.isEmpty(this.configuration.getPrompt())) {
            authRequest.queryParam("prompt", new Object[]{this.configuration.getPrompt()});
        }
        this.configuration.getExtraParameters().forEach((x$0, xva$1) -> authRequest.queryParam(x$0, new Object[]{xva$1}));
        String authUrl = authRequest.toString();
        LOGGER.log(Level.FINEST, "Redirecting for authentication to {0}", authUrl);
        try {
            response.sendRedirect(authUrl);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }

    private void storeRequestURL(HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController storage = HttpStorageController.getInstance(this.configuration, request, response);
        storage.store("oidc.original.request", this.getFullURL(request));
        if (this.configuration.isRedirectToOriginalResource()) {
            storage.store("org.glassfish.soteria.original.request.json", RequestData.of(request).toJson());
        }
    }

    private String getFullURL(HttpServletRequest request) {
        StringBuilder requestURL = new StringBuilder(request.getRequestURL().toString());
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }
}

