/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryStatisticsService;

public class PooledConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final PooledConnectionFactoryAdd INSTANCE = new PooledConnectionFactoryAdd();

    private PooledConnectionFactoryAdd() {
        super(ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES));
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            if (ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.equals(attr)) {
                if (!operation.hasDefined(ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.getName())) continue;
                ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST.validateAndSet(operation, model);
                continue;
            }
            if (ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.equals(attr)) {
                if (!operation.hasDefined(ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.getName())) continue;
                ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST.validateAndSet(operation, model);
                continue;
            }
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        ModelNode resolvedModel = model.clone();
        for (Object attribute : this.attributes) {
            resolvedModel.get(attribute.getName()).set(attribute.resolveModelAttribute(context, resolvedModel));
        }
        ArrayList<String> jndiNames = new ArrayList<String>();
        for (ModelNode node : resolvedModel.get(ConnectionFactoryAttributes.Common.ENTRIES.getName()).asList()) {
            jndiNames.add(node.asString());
        }
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)((String)jndiNames.get(0)));
        List<String> jndiAliases = jndiNames.size() > 1 ? new ArrayList(jndiNames.subList(1, jndiNames.size())) : Collections.emptyList();
        String managedConnectionPoolClassName = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()).asStringOrNull();
        int minPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).asInt();
        int maxPoolSize = resolvedModel.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).asInt();
        Boolean enlistmentTrace = resolvedModel.get(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName()).asBooleanOrNull();
        String txSupport = PooledConnectionFactoryAdd.getTxSupport(resolvedModel);
        List connectors = ConnectionFactoryAttributes.Common.CONNECTORS.unwrap((ExpressionResolver)context, model);
        String discoveryGroupName = PooledConnectionFactoryAdd.getDiscoveryGroup(resolvedModel);
        String jgroupClusterName = null;
        PathAddress serverAddress = MessagingServices.getActiveMQServerPathAddress(address);
        if (discoveryGroupName != null) {
            Resource dgResource;
            try {
                dgResource = context.readResourceFromRoot(serverAddress.append("socket-discovery-group", discoveryGroupName), false);
            }
            catch (Resource.NoSuchResourceException ex) {
                dgResource = context.readResourceFromRoot(serverAddress.append("jgroups-discovery-group", discoveryGroupName), false);
            }
            ModelNode dgModel = dgResource.getModel();
            ModelNode jgroupCluster = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, dgModel);
            if (jgroupCluster.isDefined()) {
                jgroupClusterName = jgroupCluster.asString();
            }
        }
        List<PooledConnectionFactoryConfigProperties> adapterParams = PooledConnectionFactoryAdd.getAdapterParams(resolvedModel, context, PooledConnectionFactoryDefinition.ATTRIBUTES);
        HashSet<String> connectorsSocketBindings = new HashSet<String>();
        HashSet<String> sslContextNames = new HashSet<String>();
        TransportConfiguration[] transportConfigurations = TransportConfigOperationHandlers.processConnectors(context, connectors, connectorsSocketBindings, sslContextNames);
        String serverName = serverAddress.getLastElement().getValue();
        PooledConnectionFactoryService.installService(context, name, serverName, connectors, discoveryGroupName, jgroupClusterName, adapterParams, bindInfo, jndiAliases, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, model);
        boolean statsEnabled = ConnectionFactoryAttributes.Pooled.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (statsEnabled) {
            PooledConnectionFactoryStatisticsService.registerStatisticsResources(resource);
            PooledConnectionFactoryAdd.installStatistics(context, name);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    static String getTxSupport(ModelNode resolvedModel) {
        String txType;
        switch (txType = resolvedModel.get(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()).asStringOrNull()) {
            case "local": {
                return "LocalTransaction";
            }
            case "none": {
                return "NoTransaction";
            }
        }
        return "XATransaction";
    }

    static String getDiscoveryGroup(ModelNode model) {
        if (model.hasDefined(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName())) {
            return model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()).asString();
        }
        return null;
    }

    static List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model, OperationContext context, ConnectionFactoryAttribute[] attributes) throws OperationFailedException {
        ArrayList<PooledConnectionFactoryConfigProperties> configs = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (ConnectionFactoryAttribute nodeAttribute : attributes) {
            AttributeDefinition definition;
            ModelNode node;
            if (!nodeAttribute.isResourceAdapterProperty() || !(node = (definition = nodeAttribute.getDefinition()).resolveModelAttribute(context, model)).isDefined()) continue;
            String attributeName = definition.getName();
            String value = attributeName.equals(ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST.getName()) ? String.join((CharSequence)",", ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST.unwrap((ExpressionResolver)context, model)) : (attributeName.equals(ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST.getName()) ? String.join((CharSequence)",", ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST.unwrap((ExpressionResolver)context, model)) : node.asString());
            configs.add(new PooledConnectionFactoryConfigProperties(nodeAttribute.getPropertyName(), value, nodeAttribute.getClassType(), nodeAttribute.getConfigType()));
        }
        return configs;
    }

    static void installStatistics(OperationContext context, String name) {
        ServiceName raActivatorsServiceName = PooledConnectionFactoryService.getResourceAdapterActivatorsServiceName(name);
        PooledConnectionFactoryStatisticsService statsService = new PooledConnectionFactoryStatisticsService(context.getResourceRegistrationForUpdate(), true);
        context.getServiceTarget().addService(raActivatorsServiceName.append(new String[]{"statistics"}), (Service)statsService).addDependency(raActivatorsServiceName, ResourceAdapterDeployment.class, statsService.getRADeploymentInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }
}

