/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicType;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.LeafValidators;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

abstract class AbstractTypeMappingValidator<T extends AbstractTypeMapping>
implements Validator<T> {
    private final Validator<JsonElement> extraAttributeValidator = new JsonElementValidator(new JsonElementEquivalence());

    AbstractTypeMappingValidator() {
    }

    protected abstract Validator<PropertyMapping> getPropertyMappingValidator();

    @Override
    public void validate(ValidationErrorCollector errorCollector, T expectedMapping, T actualMapping) {
        DynamicType expectedDynamic = ((AbstractTypeMapping)expectedMapping).getDynamic();
        if (expectedDynamic != null) {
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "dynamic", (Object)expectedDynamic, (Object)((AbstractTypeMapping)actualMapping).getDynamic(), (Object)DynamicType.TRUE);
        }
        this.getPropertyMappingValidator().validateAllIgnoreUnexpected(errorCollector, ValidationContextType.MAPPING_PROPERTY, ElasticsearchValidationMessages.INSTANCE.propertyMissing(), ((AbstractTypeMapping)expectedMapping).getProperties(), ((AbstractTypeMapping)actualMapping).getProperties());
        this.extraAttributeValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.CUSTOM_INDEX_MAPPING_ATTRIBUTE, ElasticsearchValidationMessages.INSTANCE.customIndexMappingAttributeMissing(), ((AbstractTypeMapping)expectedMapping).getExtraAttributes(), ((AbstractTypeMapping)actualMapping).getExtraAttributes());
    }
}

