/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorPostInsert;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorPostInsertSingleTable;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleBatched;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleNonBatched;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleSelfExecuting;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorStandard;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;

public class StandardMutationExecutorService
implements MutationExecutorService {
    private final int globalBatchSize;

    public StandardMutationExecutorService(Map<String, Object> configurationValues) {
        this(ConfigurationHelper.getInt("hibernate.jdbc.batch_size", configurationValues, 1));
    }

    public StandardMutationExecutorService(int globalBatchSize) {
        this.globalBatchSize = globalBatchSize;
    }

    @Override
    public MutationExecutor createExecutor(Supplier<BatchKey> batchKeySupplier, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        Integer sessionBatchSize = session.getJdbcCoordinator().getJdbcSessionOwner().getJdbcBatchSize();
        int batchSizeToUse = sessionBatchSize == null ? this.globalBatchSize : sessionBatchSize;
        int numberOfOperations = operationGroup.getNumberOfOperations();
        MutationType mutationType = operationGroup.getMutationType();
        MutationTarget<?> mutationTarget = operationGroup.getMutationTarget();
        if (mutationType == MutationType.INSERT && mutationTarget instanceof EntityMutationTarget && ((EntityMutationTarget)mutationTarget).getIdentityInsertDelegate() != null) {
            assert (mutationTarget instanceof EntityMappingType);
            if (numberOfOperations > 1) {
                return new MutationExecutorPostInsert(operationGroup, session);
            }
            return new MutationExecutorPostInsertSingleTable(operationGroup, session);
        }
        if (numberOfOperations == 1) {
            Object singleOperation = operationGroup.getSingleOperation();
            if (singleOperation instanceof SelfExecutingUpdateOperation) {
                return new MutationExecutorSingleSelfExecuting((SelfExecutingUpdateOperation)singleOperation, session);
            }
            PreparableMutationOperation jdbcOperation = (PreparableMutationOperation)singleOperation;
            BatchKey batchKey = batchKeySupplier.get();
            if (jdbcOperation.canBeBatched(batchKey, batchSizeToUse)) {
                return new MutationExecutorSingleBatched(jdbcOperation, batchKey, batchSizeToUse, session);
            }
            return new MutationExecutorSingleNonBatched(jdbcOperation, session);
        }
        return new MutationExecutorStandard(operationGroup, batchKeySupplier, batchSizeToUse, session);
    }
}

