/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.BasicType;
import org.hibernate.type.MetaType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.ClassJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class AnyDiscriminatorConverter
implements BasicValueConverter<Class, Object> {
    private final MetaType modelPart;
    private final BasicType discriminatorBasicType;
    private final TypeConfiguration typeConfiguration;
    private final MappingMetamodel mappingMetamodel;

    public AnyDiscriminatorConverter(MetaType modelPart, BasicType discriminatorBasicType, TypeConfiguration typeConfiguration, MappingMetamodel mappingMetamodel) {
        this.modelPart = modelPart;
        this.discriminatorBasicType = discriminatorBasicType;
        this.typeConfiguration = typeConfiguration;
        this.mappingMetamodel = mappingMetamodel;
    }

    @Override
    public Class toDomainValue(Object discriminatorValue) {
        if (discriminatorValue == null) {
            return null;
        }
        String entityName = this.modelPart.getDiscriminatorValuesToEntityNameMap().get(discriminatorValue);
        EntityPersister entityDescriptor = this.mappingMetamodel.getEntityDescriptor(entityName);
        assert (entityDescriptor.getRepresentationStrategy().getMode() == RepresentationMode.POJO);
        return entityDescriptor.getJavaType().getJavaTypeClass();
    }

    @Override
    public Object toRelationalValue(Class domainForm) {
        if (domainForm == null) {
            return null;
        }
        return this.modelPart.getEntityNameToDiscriminatorValueMap().get(domainForm.getName());
    }

    @Override
    public JavaType<Class> getDomainJavaType() {
        return this.getExpressibleJavaType();
    }

    @Override
    public JavaType<Object> getRelationalJavaType() {
        return this.discriminatorBasicType.getJavaTypeDescriptor();
    }

    public JavaType<Class> getExpressibleJavaType() {
        return ClassJavaType.INSTANCE;
    }
}

