/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.complete.CompleteFetchBuilder;
import org.hibernate.query.results.complete.ModelPartReferenceEmbeddable;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteFetchBuilderEmbeddableValuedModelPart
implements CompleteFetchBuilder,
ModelPartReferenceEmbeddable {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart modelPart;
    private final List<String> columnAliases;

    public CompleteFetchBuilderEmbeddableValuedModelPart(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, List<String> columnAliases) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.columnAliases = columnAliases;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return new CompleteFetchBuilderEmbeddableValuedModelPart(this.navigablePath, this.modelPart, List.copyOf(this.columnAliases));
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EmbeddableValuedModelPart getReferencedPart() {
        return this.modelPart;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnAliases;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        assert (fetchPath.equals(this.navigablePath));
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
        this.modelPart.forEachSelectable((selectionIndex, selectableMapping) -> {
            TableReference tableReference = tableGroup.resolveTableReference(this.navigablePath, selectableMapping.getContainingTableExpression());
            String columnAlias = this.columnAliases.get(selectionIndex);
            creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, selectableMapping, columnAlias), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, creationStateImpl.getSessionFactory().getTypeConfiguration());
        });
        return parent.generateFetchableFetch(this.modelPart, fetchPath, FetchTiming.IMMEDIATE, true, null, domainResultCreationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteFetchBuilderEmbeddableValuedModelPart that = (CompleteFetchBuilderEmbeddableValuedModelPart)o;
        return this.navigablePath.equals(that.navigablePath) && this.modelPart.equals(that.modelPart) && this.columnAliases.equals(that.columnAliases);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.modelPart.hashCode();
        result = 31 * result + this.columnAliases.hashCode();
        return result;
    }
}

