/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.model.TableMapping;

public class MutatingTableReference
implements TableReference {
    private final TableMapping tableMapping;

    public MutatingTableReference(TableMapping tableMapping) {
        this.tableMapping = tableMapping;
    }

    public TableMapping getTableMapping() {
        return this.tableMapping;
    }

    public String getTableName() {
        return this.tableMapping.getTableName();
    }

    @Override
    public String getIdentificationVariable() {
        return null;
    }

    @Override
    public String getTableId() {
        return this.getTableName();
    }

    @Override
    public boolean isOptional() {
        return this.tableMapping.isOptional();
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        throw new UnsupportedOperationException("Mutating table reference should be handled by the statement visitation");
    }

    @Override
    public Boolean visitAffectedTableNames(Function<String, Boolean> nameCollector) {
        return nameCollector.apply(this.getTableName());
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        if (this.getTableName().equals(tableExpression)) {
            return this;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Table-expression (%s) did not match mutating table name - %s", tableExpression, this.getTableName()));
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        return this.resolveTableReference(navigablePath, tableExpression, allowFkOptimization);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutatingTableReference that = (MutatingTableReference)o;
        return Objects.equals(this.getTableName(), that.getTableName());
    }

    public int hashCode() {
        return Objects.hash(this.getTableName());
    }

    public String toString() {
        return "MutatingTableReference(" + this.getTableName() + ")";
    }
}

