/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterArray;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicArrayType<T>
extends AbstractSingleColumnStandardBasicType<T[]>
implements AdjustableBasicType<T[]>,
BasicPluralType<T[], T> {
    private final BasicType<T> baseDescriptor;
    private final String name;
    private final ValueBinder<T[]> jdbcValueBinder;
    private final ValueExtractor<T[]> jdbcValueExtractor;
    private final JdbcLiteralFormatter<T[]> jdbcLiteralFormatter;

    public BasicArrayType(final BasicType<T> baseDescriptor, JdbcType arrayJdbcType, JavaType<T[]> arrayTypeDescriptor) {
        super(arrayJdbcType, arrayTypeDescriptor);
        this.baseDescriptor = baseDescriptor;
        this.name = baseDescriptor.getName() + "[]";
        final ValueBinder jdbcValueBinder = super.getJdbcValueBinder();
        final ValueExtractor jdbcValueExtractor = super.getJdbcValueExtractor();
        JdbcLiteralFormatter jdbcLiteralFormatter = super.getJdbcLiteralFormatter();
        final BasicValueConverter<T, ?> valueConverter = baseDescriptor.getValueConverter();
        if (valueConverter != null) {
            this.jdbcValueBinder = new ValueBinder<T[]>(){

                @Override
                public void bind(PreparedStatement st, T[] value, int index, WrapperOptions options) throws SQLException {
                    jdbcValueBinder.bind(st, this.getValue(value, valueConverter, options), index, options);
                }

                @Override
                public void bind(CallableStatement st, T[] value, String name, WrapperOptions options) throws SQLException {
                    jdbcValueBinder.bind(st, this.getValue(value, valueConverter, options), name, options);
                }

                private T[] getValue(T[] value, BasicValueConverter<T, Object> valueConverter2, WrapperOptions options) {
                    if (value == null) {
                        return null;
                    }
                    JdbcType elementJdbcType = baseDescriptor.getJdbcType();
                    TypeConfiguration typeConfiguration = options.getSessionFactory().getTypeConfiguration();
                    JdbcType underlyingJdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(elementJdbcType.getDefaultSqlTypeCode());
                    Class<?> preferredJavaTypeClass = underlyingJdbcType.getPreferredJavaTypeClass(options);
                    Class<Object> elementJdbcJavaTypeClass = preferredJavaTypeClass == null ? underlyingJdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration).getJavaTypeClass() : preferredJavaTypeClass;
                    if (value.getClass().getComponentType() == elementJdbcJavaTypeClass) {
                        return value;
                    }
                    Object[] array = (Object[])Array.newInstance(elementJdbcJavaTypeClass, value.length);
                    for (int i = 0; i < value.length; ++i) {
                        array[i] = valueConverter2.getRelationalJavaType().unwrap(valueConverter2.toRelationalValue(value[i]), elementJdbcJavaTypeClass, options);
                    }
                    return array;
                }
            };
            this.jdbcValueExtractor = new ValueExtractor<T[]>(){

                @Override
                public T[] extract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return this.getValue((Object[])jdbcValueExtractor.extract(rs, paramIndex, options), valueConverter);
                }

                @Override
                public T[] extract(CallableStatement statement, int paramIndex, WrapperOptions options) throws SQLException {
                    return this.getValue((Object[])jdbcValueExtractor.extract(statement, paramIndex, options), valueConverter);
                }

                @Override
                public T[] extract(CallableStatement statement, String paramName, WrapperOptions options) throws SQLException {
                    return this.getValue((Object[])jdbcValueExtractor.extract(statement, paramName, options), valueConverter);
                }

                private T[] getValue(T[] value, BasicValueConverter<T, Object> valueConverter2) {
                    if (value == null) {
                        return null;
                    }
                    if (value.getClass().getComponentType() == valueConverter2.getDomainJavaType().getJavaTypeClass()) {
                        return value;
                    }
                    Object[] array = (Object[])Array.newInstance(valueConverter2.getDomainJavaType().getJavaTypeClass(), value.length);
                    for (int i = 0; i < value.length; ++i) {
                        array[i] = valueConverter2.toDomainValue(value[i]);
                    }
                    return array;
                }
            };
            this.jdbcLiteralFormatter = new JdbcLiteralFormatterArray<T[]>(baseDescriptor.getJavaTypeDescriptor(), jdbcLiteralFormatter);
        } else {
            this.jdbcValueBinder = jdbcValueBinder;
            this.jdbcValueExtractor = jdbcValueExtractor;
            this.jdbcLiteralFormatter = jdbcLiteralFormatter;
        }
    }

    @Override
    public BasicType<T> getElementType() {
        return this.baseDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public ValueExtractor<T[]> getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    @Override
    public ValueBinder<T[]> getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public JdbcLiteralFormatter getJdbcLiteralFormatter() {
        return this.jdbcLiteralFormatter;
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<X> domainJtd) {
        return this;
    }
}

