/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import java.io.Serializable;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.converter.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class OrdinalEnumValueConverter<E extends Enum<E>, N extends Number>
implements EnumValueConverter<E, N>,
Serializable {
    private final EnumJavaType<E> enumJavaType;
    private final JdbcType jdbcType;
    private final JavaType<N> relationalJavaType;

    public OrdinalEnumValueConverter(EnumJavaType<E> enumJavaType, JdbcType jdbcType, JavaType<N> relationalJavaType) {
        this.enumJavaType = enumJavaType;
        this.jdbcType = jdbcType;
        this.relationalJavaType = relationalJavaType;
    }

    @Override
    public E toDomainValue(Number relationalForm) {
        return this.enumJavaType.fromOrdinal(relationalForm == null ? null : Integer.valueOf(relationalForm.intValue()));
    }

    @Override
    public N toRelationalValue(E domainForm) {
        return (N)this.enumJavaType.toOrdinal(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcType.getDefaultSqlTypeCode();
    }

    @Override
    public EnumJavaType<E> getDomainJavaType() {
        return this.enumJavaType;
    }

    @Override
    public JavaType<N> getRelationalJavaType() {
        return this.relationalJavaType;
    }

    @Override
    public String toSqlLiteral(Object value) {
        return Integer.toString(((Enum)value).ordinal());
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType jdbcType, Dialect dialect) {
        int max = ((Enum[])((AbstractClassJavaType)this.getDomainJavaType()).getJavaTypeClass().getEnumConstants()).length - 1;
        return dialect.getCheckCondition(columnName, 0L, max);
    }
}

