/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import jakarta.enterprise.context.spi.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.weld.bean.builtin.BeanManagerBean;
import org.jboss.weld.bean.builtin.BeanManagerImplBean;
import org.jboss.weld.bean.builtin.BeanMetadataBean;
import org.jboss.weld.bean.builtin.ContextBean;
import org.jboss.weld.bean.builtin.ConversationBean;
import org.jboss.weld.bean.builtin.DecoratedBeanMetadataBean;
import org.jboss.weld.bean.builtin.DecoratorMetadataBean;
import org.jboss.weld.bean.builtin.EventBean;
import org.jboss.weld.bean.builtin.EventMetadataBean;
import org.jboss.weld.bean.builtin.InjectionPointBean;
import org.jboss.weld.bean.builtin.InstanceBean;
import org.jboss.weld.bean.builtin.InterceptedBeanMetadataBean;
import org.jboss.weld.bean.builtin.InterceptionFactoryBean;
import org.jboss.weld.bean.builtin.InterceptorMetadataBean;
import org.jboss.weld.bean.builtin.RequestContextControllerBean;
import org.jboss.weld.bean.builtin.ee.PrincipalBean;
import org.jboss.weld.bean.proxy.InterceptionFactoryDataCache;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployments;
import org.jboss.weld.bootstrap.ConcurrentBeanDeployer;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.interceptor.builder.InterceptorsApiAbstraction;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.metadata.FilterPredicate;
import org.jboss.weld.metadata.ScanningPredicate;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.module.WeldModules;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.NoopSecurityServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.util.AnnotationApiAbstraction;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.ws.WSApiAbstraction;

public class BeanDeployment {
    private final BeanDeploymentArchive beanDeploymentArchive;
    private final BeanManagerImpl beanManager;
    private final BeanDeployer beanDeployer;
    private final Collection<ContextHolder<? extends Context>> contexts;

    public BeanDeployment(BeanDeploymentArchive beanDeploymentArchive, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices, Collection<ContextHolder<? extends Context>> contexts) {
        this(beanDeploymentArchive, deploymentManager, deploymentServices, contexts, false);
    }

    public BeanDeployment(BeanDeploymentArchive beanDeploymentArchive, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices, Collection<ContextHolder<? extends Context>> contexts, boolean additionalBeanArchive) {
        this.beanDeploymentArchive = beanDeploymentArchive;
        ServiceRegistry registry = beanDeploymentArchive.getServices();
        ResourceLoader resourceLoader = (ResourceLoader)registry.get(ResourceLoader.class);
        if (resourceLoader == null) {
            resourceLoader = DefaultResourceLoader.INSTANCE;
            registry.add(ResourceLoader.class, (Service)resourceLoader);
        }
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.addAll((Collection)deploymentServices.entrySet());
        services.addAll((Collection)registry.entrySet());
        services.add(PersistenceApiAbstraction.class, (Service)new PersistenceApiAbstraction(resourceLoader));
        services.add(WSApiAbstraction.class, (Service)new WSApiAbstraction(resourceLoader));
        services.add(InterceptorsApiAbstraction.class, (Service)new InterceptorsApiAbstraction(resourceLoader));
        services.add(AnnotationApiAbstraction.class, (Service)new AnnotationApiAbstraction(resourceLoader));
        this.beanManager = BeanManagerImpl.newManager(deploymentManager, BeanDeployments.getFinalId(beanDeploymentArchive.getId(), ((WeldConfiguration)services.get(WeldConfiguration.class)).getStringProperty(ConfigurationKey.ROLLING_UPGRADES_ID_DELIMITER)), (ServiceRegistry)services);
        services.add(InjectionTargetService.class, (Service)new InjectionTargetService(this.beanManager));
        services.add(InterceptionFactoryDataCache.class, (Service)new InterceptionFactoryDataCache(this.beanManager));
        ((WeldModules)services.get(WeldModules.class)).postBeanArchiveServiceRegistration((ServiceRegistry)services, this.beanManager, beanDeploymentArchive);
        services.addIfAbsent(EjbSupport.class, (Service)EjbSupport.NOOP_IMPLEMENTATION);
        this.beanDeployer = ((WeldConfiguration)services.get(WeldConfiguration.class)).getBooleanProperty(ConfigurationKey.CONCURRENT_DEPLOYMENT) != false && services.contains(ExecutorServices.class) ? new ConcurrentBeanDeployer(this.beanManager, deploymentServices) : new BeanDeployer(this.beanManager, deploymentServices);
        ((SpecializationAndEnablementRegistry)this.beanManager.getServices().get(SpecializationAndEnablementRegistry.class)).registerEnvironment(this.beanManager, (BeanDeployerEnvironment)this.beanDeployer.getEnvironment(), additionalBeanArchive);
        this.beanManager.addBean(new BeanManagerBean(this.beanManager));
        this.beanManager.addBean(new BeanManagerImplBean(this.beanManager));
        this.contexts = contexts;
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public BeanDeployer getBeanDeployer() {
        return this.beanDeployer;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.beanDeploymentArchive;
    }

    private Predicate<String> createFilter() {
        if (this.getBeanDeploymentArchive().getBeansXml() == null || this.getBeanDeploymentArchive().getBeansXml().getScanning() == null) {
            return null;
        }
        Function<Metadata<Filter>, Predicate<String>> filterToPredicateFunction = new Function<Metadata<Filter>, Predicate<String>>(){
            final ResourceLoader resourceLoader;
            {
                this.resourceLoader = BeanDeployment.this.beanDeployer.getResourceLoader();
            }

            @Override
            public Predicate<String> apply(Metadata<Filter> from) {
                return new FilterPredicate(from, this.resourceLoader);
            }
        };
        Collection<Object> includeFilters = this.getBeanDeploymentArchive().getBeansXml().getScanning().getIncludes() != null ? this.getBeanDeploymentArchive().getBeansXml().getScanning().getIncludes() : Collections.emptyList();
        Collection<Object> excludeFilters = this.getBeanDeploymentArchive().getBeansXml().getScanning().getExcludes() != null ? this.getBeanDeploymentArchive().getBeansXml().getScanning().getExcludes() : Collections.emptyList();
        Collection includes = includeFilters.stream().map(filterToPredicateFunction).collect(Collectors.toList());
        Collection excludes = excludeFilters.stream().map(filterToPredicateFunction).collect(Collectors.toList());
        return new ScanningPredicate<String>(includes, excludes);
    }

    public void createClasses() {
        Predicate<String> filter;
        Stream<Object> classNames = this.beanDeploymentArchive.getBeanClasses().stream();
        Collection loadedClasses = this.beanDeploymentArchive.getLoadedBeanClasses();
        if (!loadedClasses.isEmpty()) {
            Set preloadedClassNames = loadedClasses.stream().map(c -> c.getName()).collect(Collectors.toSet());
            classNames = classNames.filter(name -> !preloadedClassNames.contains(name));
        }
        if ((filter = this.createFilter()) != null) {
            classNames = classNames.filter(filter);
            loadedClasses = loadedClasses.stream().filter(clazz -> filter.test(clazz.getName())).collect(Collectors.toSet());
        }
        this.beanDeployer.addLoadedClasses(loadedClasses);
        this.beanDeployer.addClasses(classNames.collect(Collectors.toSet()));
    }

    public void createEnablement() {
        GlobalEnablementBuilder builder = (GlobalEnablementBuilder)this.beanManager.getServices().get(GlobalEnablementBuilder.class);
        ModuleEnablement enablement = builder.createModuleEnablement(this);
        this.beanManager.setEnabled(enablement);
        if (BootstrapLogger.LOG.isDebugEnabled()) {
            BootstrapLogger.LOG.enabledAlternatives(this.beanManager, WeldCollections.toMultiRowString(enablement.getAllAlternatives()));
            BootstrapLogger.LOG.enabledDecorators(this.beanManager, WeldCollections.toMultiRowString(enablement.getDecorators()));
            BootstrapLogger.LOG.enabledInterceptors(this.beanManager, WeldCollections.toMultiRowString(enablement.getInterceptors()));
        }
    }

    public void createTypes() {
        this.beanDeployer.processAnnotatedTypes();
        this.beanDeployer.registerAnnotatedTypes();
    }

    public void createBeans(Environment environment) {
        ((WeldModules)this.getBeanManager().getServices().get(WeldModules.class)).preBeanRegistration(this, environment);
        if (this.getBeanManager().getServices().get(EjbSupport.class) == EjbSupport.NOOP_IMPLEMENTATION) {
            this.beanDeployer.addBuiltInBean(new InjectionPointBean(this.beanManager));
        }
        this.beanDeployer.addBuiltInBean(new EventMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new EventBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new InstanceBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new ConversationBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new BeanMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new InterceptedBeanMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new DecoratedBeanMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new InterceptorMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new DecoratorMetadataBean(this.beanManager));
        this.beanDeployer.addBuiltInBean(new InterceptionFactoryBean(this.beanManager));
        if (this.beanManager.getServices().getRequired(SecurityServices.class) != NoopSecurityServices.INSTANCE) {
            this.beanDeployer.addBuiltInBean(new PrincipalBean(this.beanManager));
        }
        for (ContextHolder<? extends Context> context : this.contexts) {
            this.beanDeployer.addBuiltInBean(ContextBean.of(context, this.beanManager));
        }
        this.beanDeployer.addBuiltInBean(new RequestContextControllerBean(this.beanManager));
        if (this.beanDeploymentArchive.getBeansXml() != null && this.beanDeploymentArchive.getBeansXml().isTrimmed()) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).trim();
        }
        this.beanDeployer.createClassBeans();
    }

    public void deploySpecialized(Environment environment) {
        this.beanDeployer.deploySpecialized();
    }

    public void deployBeans(Environment environment) {
        this.beanDeployer.deploy();
    }

    public void afterBeanDiscovery(Environment environment) {
        this.beanDeployer.doAfterBeanDiscovery(this.beanManager.getBeans());
        this.beanDeployer.doAfterBeanDiscovery(this.beanManager.getDecorators());
        this.beanDeployer.doAfterBeanDiscovery(this.beanManager.getInterceptors());
        this.beanDeployer.registerCdiInterceptorsForMessageDrivenBeans();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BeanDeployment ");
        builder.append("[beanDeploymentArchiveId=");
        builder.append(this.beanDeploymentArchive.getId());
        if (!this.beanDeploymentArchive.getId().equals(this.beanManager.getId())) {
            builder.append(", beanManagerId=");
            builder.append(this.beanManager.getId());
        }
        builder.append("]");
        return builder.toString();
    }
}

