/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.topology.RebalancingStatus;

public class RebalanceStatusRequestCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 90;
    private String cacheName;

    public RebalanceStatusRequestCommand() {
        super((byte)90);
    }

    public RebalanceStatusRequestCommand(String cacheName) {
        super((byte)90);
        this.cacheName = cacheName;
    }

    public CompletionStage<RebalancingStatus> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        RebalancingStatus status = this.cacheName == null ? (gcr.getClusterTopologyManager().isRebalancingEnabled() ? RebalancingStatus.PENDING : RebalancingStatus.SUSPENDED) : gcr.getClusterTopologyManager().getRebalancingStatus(this.cacheName);
        return CompletableFuture.completedFuture(status);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
    }

    public String toString() {
        return "RebalanceStatusCommand{cacheName='" + this.cacheName + "'}";
    }
}

