/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.loader.LoaderLogging;
import org.hibernate.persister.entity.EntityPersister;

public class LoaderHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource session) {
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
        }
        EntityPersister persister = entry.getPersister();
        if (LoaderLogging.TRACE_ENABLED) {
            LoaderLogging.LOADER_LOGGER.tracef("Locking `%s( %s )` in `%s` lock-mode", (Object)persister.getEntityName(), entry.getId(), (Object)requestedLockMode);
        }
        boolean cachingEnabled = persister.canWriteToCache();
        SoftLock lock = null;
        Object ck = null;
        try {
            if (cachingEnabled) {
                EntityDataAccess cache = persister.getCacheAccessStrategy();
                ck = cache.generateCacheKey(entry.getId(), persister, session.getFactory(), session.getTenantIdentifier());
                lock = cache.lockItem(session, ck, entry.getVersion());
            }
            if (persister.isVersioned() && requestedLockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
                Object nextVersion = persister.forceVersionIncrement(entry.getId(), entry.getVersion(), session);
                entry.forceLocked(object, nextVersion);
            } else {
                persister.lock(entry.getId(), entry.getVersion(), object, lockOptions, session);
            }
            entry.setLockMode(requestedLockMode);
            if (!cachingEnabled) return;
        }
        catch (Throwable throwable) {
            if (!cachingEnabled) throw throwable;
            persister.getCacheAccessStrategy().unlockItem(session, ck, lock);
            throw throwable;
        }
        persister.getCacheAccessStrategy().unlockItem(session, ck, lock);
    }
}

