/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.spi.ListResultsConsumer;

@Incubating
public class GeneratedValuesProcessor {
    private final SelectStatement selectStatement;
    private final List<AttributeMapping> generatedValuesToSelect;
    private final List<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;

    public GeneratedValuesProcessor(EntityMappingType entityDescriptor, EventType timing, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
        this.generatedValuesToSelect = GeneratedValuesProcessor.getGeneratedAttributes(entityDescriptor, timing);
        this.selectStatement = this.generatedValuesToSelect.isEmpty() ? null : LoaderSelectBuilder.createSelect((Loadable)entityDescriptor, this.generatedValuesToSelect, entityDescriptor.getIdentifierMapping(), null, 1, LoadQueryInfluencers.NONE, LockOptions.READ, this.jdbcParameters::add, sessionFactory);
    }

    private static List<AttributeMapping> getGeneratedAttributes(EntityMappingType entityDescriptor, EventType timing) {
        Generator[] generators = entityDescriptor.getEntityPersister().getEntityMetamodel().getGenerators();
        ArrayList<AttributeMapping> generatedValuesToSelect = new ArrayList<AttributeMapping>();
        entityDescriptor.forEachAttributeMapping(mapping -> {
            Generator generator = generators[mapping.getStateArrayPosition()];
            if (generator != null && generator.generatedOnExecution() && generator.getEventTypes().contains((Object)timing)) {
                generatedValuesToSelect.add((AttributeMapping)mapping);
            }
        });
        return generatedValuesToSelect;
    }

    public void processGeneratedValues(Object entity, Object id, Object[] state, SharedSessionContractImplementor session) {
        if (this.selectStatement != null) {
            List<Object[]> results = this.executeSelect(id, session);
            assert (results.size() == 1);
            this.setEntityAttributes(entity, state, results.get(0));
        }
    }

    private List<Object[]> executeSelect(Object id, SharedSessionContractImplementor session) {
        JdbcParameterBindings jdbcParamBindings = this.getJdbcParameterBindings(id, session);
        JdbcOperationQuerySelect jdbcSelect = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.sessionFactory, this.selectStatement).translate(jdbcParamBindings, QueryOptions.NONE);
        return session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new NoCallbackExecutionContext(session), row -> row, ListResultsConsumer.UniqueSemantic.FILTER);
    }

    private JdbcParameterBindings getJdbcParameterBindings(Object id, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        return jdbcParamBindings;
    }

    private void setEntityAttributes(Object entity, Object[] state, Object[] selectionResults) {
        for (int i = 0; i < this.generatedValuesToSelect.size(); ++i) {
            Object generatedValue;
            AttributeMapping attribute = this.generatedValuesToSelect.get(i);
            state[attribute.getStateArrayPosition()] = generatedValue = selectionResults[i];
            attribute.getAttributeMetadata().getPropertyAccess().getSetter().set(entity, generatedValue);
        }
    }

    public SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public List<AttributeMapping> getGeneratedValuesToSelect() {
        return this.generatedValuesToSelect;
    }

    public List<JdbcParameter> getJdbcParameters() {
        return this.jdbcParameters;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

