/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet._private;

import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobException;
import java.io.Serializable;
import java.security.Permission;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.batch.jberet._private.BatchLogger;

public class BatchLogger_$logger
extends DelegatingBasicLogger
implements BatchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BatchLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public BatchLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String errorProcessingBatchJobsDir$str() {
        return "WFLYBATCH000001: Error processing META-INF/batch-jobs directory.";
    }

    @Override
    public final DeploymentUnitProcessingException errorProcessingBatchJobsDir(Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorProcessingBatchJobsDir$str(), new Object[0]), cause);
        BatchLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String cannotRemoveResourceOfType$str() {
        return "WFLYBATCH000002: Resources of type %s cannot be removed";
    }

    @Override
    public final UnsupportedOperationException cannotRemoveResourceOfType(String childType) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.cannotRemoveResourceOfType$str(), childType));
        BatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotFindDeploymentName$str() {
        return "WFLYBATCH000003: Could not find deployment name: %s";
    }

    @Override
    public final IllegalArgumentException couldNotFindDeploymentName(String address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotFindDeploymentName$str(), address));
        BatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jobOperatorServiceStopped$str() {
        return "WFLYBATCH000004: The service JobOperatorService has been stopped and cannot execute operations.";
    }

    @Override
    public final IllegalStateException jobOperatorServiceStopped() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.jobOperatorServiceStopped$str(), new Object[0]));
        BatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchJobException$str() {
        return "WFLYBATCH000005: The job name '%s' was not found for the deployment.";
    }

    @Override
    public final NoSuchJobException noSuchJobException(String jobName) {
        NoSuchJobException result = new NoSuchJobException(String.format(this.getLoggingLocale(), this.noSuchJobException$str(), jobName));
        BatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotFindJobXml$str() {
        return "WFLYBATCH000006: Could not find the job XML file in the deployment: %s";
    }

    @Override
    public final JobStartException couldNotFindJobXml(String xmlFile) {
        JobStartException result = new JobStartException(String.format(this.getLoggingLocale(), this.couldNotFindJobXml$str(), xmlFile));
        BatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidJobXmlFile(String jobXmlFile) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidJobXmlFile$str(), (Object)jobXmlFile);
    }

    protected String invalidJobXmlFile$str() {
        return "WFLYBATCH000007: Failed processing the job XML file %s. Attempting to execute this job may result in errors.";
    }

    @Override
    public final void emptyJobRepositoryElement(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.emptyJobRepositoryElement$str(), (Object)deploymentName);
    }

    protected String emptyJobRepositoryElement$str() {
        return "WFLYBATCH000008: Empty job-repository element found in deployment descriptor. Using the default job repository for deployment %s.";
    }

    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return "WFLYBATCH000009: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    }

    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement address) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.indexedChildResourceRegistrationNotAvailable$str(), address));
        BatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToCreateJobRepository$str() {
        return "WFLYBATCH000011: Failed to create %s job repository.";
    }

    @Override
    public final StartException failedToCreateJobRepository(Throwable cause, String type) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToCreateJobRepository$str(), type), cause);
        BatchLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void multipleJobRepositoriesFound() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.multipleJobRepositoriesFound$str(), new Object[0]);
    }

    protected String multipleJobRepositoriesFound$str() {
        return "WFLYBATCH000013: Only one job repository can be defined in the jboss-all.xml deployment descriptor. The first job repository will be used.";
    }

    @Override
    public final void stoppingJob(long executionId, String jobName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.stoppingJob$str(), (Object)executionId, (Object)jobName, (Object)deploymentName);
    }

    protected String stoppingJob$str() {
        return "WFLYBATCH000014: Stopping execution %d of %s for deployment %s";
    }

    @Override
    public final void stoppingJobFailed(Throwable cause, long executionId, String jobName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.stoppingJobFailed$str(), (Object)executionId, (Object)jobName, (Object)deploymentName);
    }

    protected String stoppingJobFailed$str() {
        return "WFLYBATCH000015: Failed to stop execution %d for job %s on deployment %s";
    }

    @Override
    public final void failedRestartingJob(Throwable cause, long executionId, String jobName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedRestartingJob$str(), (Object)executionId, (Object)jobName, (Object)deploymentName);
    }

    protected String failedRestartingJob$str() {
        return "WFLYBATCH000016: Failed to restart execution %d for job %s on deployment %s";
    }

    @Override
    public final void restartingJob(String jobName, long previousId, long newId) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.restartingJob$str(), (Object)jobName, (Object)previousId, (Object)newId);
    }

    protected String restartingJob$str() {
        return "WFLYBATCH000017: Restarting previously stopped batch job %s. Previous execution id %d. New execution id %d.";
    }

    protected String noBatchEnvironmentFound$str() {
        return "WFLYBATCH000019: No batch environment was found for class loader: %s";
    }

    @Override
    public final BatchRuntimeException noBatchEnvironmentFound(ClassLoader cl) {
        BatchRuntimeException result = new BatchRuntimeException(String.format(this.getLoggingLocale(), this.noBatchEnvironmentFound$str(), cl));
        BatchLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unauthorized$str() {
        return "WFLYBATCH000020: Permission denied. User %s does not have %s permissions.";
    }

    @Override
    public final JobSecurityException unauthorized(String user, Permission permission) {
        JobSecurityException result = new JobSecurityException(String.format(this.getLoggingLocale(), this.unauthorized$str(), user, permission));
        BatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

