/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.schema.management.impl;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.schema.management.impl.PojoSchemaManagementIndexedTypeContext;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;

public class PojoScopeSchemaManagerImpl
implements PojoScopeSchemaManager {
    private final Set<? extends PojoSchemaManagementIndexedTypeContext> targetedTypeContexts;

    public PojoScopeSchemaManagerImpl(Set<? extends PojoSchemaManagementIndexedTypeContext> targetedTypeContexts) {
        this.targetedTypeContexts = targetedTypeContexts;
    }

    @Override
    public CompletableFuture<?> createIfMissing(FailureCollector failureCollector) {
        return this.doOperationOnTypes(IndexSchemaManager::createIfMissing, failureCollector);
    }

    @Override
    public CompletableFuture<?> createOrValidate(FailureCollector failureCollector) {
        return this.doOperationOnTypes(IndexSchemaManager::createOrValidate, failureCollector);
    }

    @Override
    public CompletableFuture<?> createOrUpdate(FailureCollector failureCollector) {
        return this.doOperationOnTypes(IndexSchemaManager::createOrUpdate, failureCollector);
    }

    @Override
    public CompletableFuture<?> dropAndCreate(FailureCollector failureCollector) {
        return this.doOperationOnTypes(IndexSchemaManager::dropAndCreate, failureCollector);
    }

    @Override
    public CompletableFuture<?> dropIfExisting(FailureCollector failureCollector) {
        return this.doOperationOnTypes(IndexSchemaManager::dropIfExisting, failureCollector);
    }

    @Override
    public CompletableFuture<?> validate(FailureCollector failureCollector) {
        return this.doOperationOnTypes(IndexSchemaManager::validate, failureCollector);
    }

    private CompletableFuture<?> doOperationOnTypes(Function<IndexSchemaManager, CompletableFuture<?>> operation, FailureCollector failureCollector) {
        return this.doOperationOnTypes((IndexSchemaManager schemaManager, ContextualFailureCollector typeFailureCollector) -> (CompletableFuture)operation.apply((IndexSchemaManager)schemaManager), failureCollector);
    }

    private CompletableFuture<?> doOperationOnTypes(BiFunction<IndexSchemaManager, ContextualFailureCollector, CompletableFuture<?>> operation, FailureCollector failureCollector) {
        CompletableFuture[] futures = new CompletableFuture[this.targetedTypeContexts.size()];
        int typeCounter = 0;
        for (PojoSchemaManagementIndexedTypeContext pojoSchemaManagementIndexedTypeContext : this.targetedTypeContexts) {
            IndexSchemaManager delegate = pojoSchemaManagementIndexedTypeContext.schemaManager();
            ContextualFailureCollector typeFailureCollector = failureCollector.withContext(PojoEventContexts.fromType(pojoSchemaManagementIndexedTypeContext.typeIdentifier()));
            futures[typeCounter++] = operation.apply(delegate, typeFailureCollector).exceptionally(Futures.handler(e -> {
                typeFailureCollector.add((Throwable)Throwables.expectException((Throwable)e));
                return null;
            }));
        }
        return CompletableFuture.allOf(futures);
    }
}

