/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.io.Serializable;

public abstract class Transition<T>
implements Serializable {
    private static final long serialVersionUID = -112488607616329302L;
    private String on;
    transient T enclosingBuilder;

    public Transition(String on) {
        this.on = on;
    }

    public String getOn() {
        return this.on;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public static final class Next<T>
    extends Transition<T> {
        private static final long serialVersionUID = 6985540748982496047L;
        private String to;

        public Next(String on) {
            super(on);
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public T to(String nextToRun) {
            this.to = nextToRun;
            Object builder = this.enclosingBuilder;
            this.enclosingBuilder = null;
            return (T)builder;
        }
    }

    public static final class Stop<T>
    extends Termination<T> {
        private static final long serialVersionUID = -460513093260191729L;
        private String restart;

        public Stop(String on, String restart) {
            super(on);
            this.restart = restart;
        }

        public String getRestart() {
            return this.restart;
        }

        public void setRestart(String restart) {
            this.restart = restart;
        }

        public Stop<T> restartFrom(String restartFrom) {
            this.restart = restartFrom;
            return this;
        }
    }

    public static final class Fail<T>
    extends Termination<T> {
        private static final long serialVersionUID = -5653099756045482389L;

        public Fail(String on) {
            super(on);
        }
    }

    public static final class End<T>
    extends Termination<T> {
        private static final long serialVersionUID = -6145098395052085455L;

        public End(String on) {
            super(on);
        }
    }

    public static abstract class Termination<T>
    extends Transition<T> {
        private static final long serialVersionUID = 4417648893108466995L;
        private String exitStatus;

        public Termination(String on) {
            super(on);
        }

        public final String getExitStatus() {
            return this.exitStatus;
        }

        public void setExitStatus(String exitStatus) {
            this.exitStatus = exitStatus;
        }

        public T exitStatus(String ... newExitStatus) {
            if (newExitStatus.length > 0) {
                this.exitStatus = newExitStatus[0];
            }
            Object builder = this.enclosingBuilder;
            this.enclosingBuilder = null;
            return (T)builder;
        }
    }
}

