/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.ObjectMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.ConnectionFactoryOptions;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.utils.ObjectInputStreamWithClassLoader;

public class HornetQObjectMessage
extends HornetQMessage
implements ObjectMessage {
    public static final byte TYPE = 2;
    private byte[] data;
    private final ConnectionFactoryOptions options;

    protected HornetQObjectMessage(ClientSession session, ConnectionFactoryOptions options) {
        super((byte)2, session);
        this.options = options;
    }

    protected HornetQObjectMessage(ClientMessage message, ClientSession session, ConnectionFactoryOptions options) {
        super(message, session);
        this.options = options;
    }

    public HornetQObjectMessage(ObjectMessage foreign, ClientSession session, ConnectionFactoryOptions options) throws JMSException {
        super((Message)foreign, (byte)2, session);
        this.setObject(foreign.getObject());
        this.options = options;
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.message.getBodyBuffer().clear();
        if (this.data != null) {
            this.message.getBodyBuffer().writeInt(this.data.length);
            this.message.getBodyBuffer().writeBytes(this.data);
        }
        super.doBeforeSend();
    }

    @Override
    public void doBeforeReceive() throws HornetQException {
        super.doBeforeReceive();
        try {
            int len = this.message.getBodyBuffer().readInt();
            this.data = new byte[len];
            this.message.getBodyBuffer().readBytes(this.data);
        }
        catch (Exception e) {
            this.data = null;
        }
    }

    public void setObject(Serializable object) throws JMSException {
        this.checkWrite();
        if (object != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                oos.flush();
                this.data = baos.toByteArray();
            }
            catch (Exception e) {
                JMSException je = new JMSException("Failed to serialize object");
                je.setLinkedException(e);
                je.initCause((Throwable)e);
                throw je;
            }
        }
    }

    public Serializable getObject() throws JMSException {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        try {
            String whiteList;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais);
            String blackList = this.getDeserializationBlackList();
            if (blackList != null) {
                ois.setBlackList(blackList);
            }
            if ((whiteList = this.getDeserializationWhiteList()) != null) {
                ois.setWhiteList(whiteList);
            }
            Serializable object = (Serializable)ois.readObject();
            return object;
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.setStackTrace(e.getStackTrace());
            throw je;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.data = null;
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) throws MessageFormatException {
        try {
            return (T)this.getObject();
        }
        catch (JMSException e) {
            throw new MessageFormatException("Deserialization error on HornetQObjectMessage");
        }
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        if (this.data == null) {
            return true;
        }
        try {
            return Serializable.class == c || Object.class == c || c.isInstance(this.getObject());
        }
        catch (JMSException e) {
            return false;
        }
    }

    private String getDeserializationBlackList() {
        if (this.options == null) {
            return null;
        }
        return this.options.getDeserializationBlackList();
    }

    private String getDeserializationWhiteList() {
        if (this.options == null) {
            return null;
        }
        return this.options.getDeserializationWhiteList();
    }
}

