/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import jakarta.persistence.OptimisticLockException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class OutboxEventLoader {
    private static final String LOAD_QUERY = "select e from OutboxEvent e where e.id in (:ids)";
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public static OutboxEventLoader create(Dialect dialect) {
        if (dialect.supportsSkipLocked()) {
            return new SkipLockedOutboxEventLoader();
        }
        return new LockAllOutboxEventLoader();
    }

    OutboxEventLoader() {
    }

    List<OutboxEvent> loadLocking(Session session, Set<Long> ids, String processorName) {
        try {
            return this.tryLoadLocking(session, ids);
        }
        catch (OptimisticLockException lockException) {
            log.outboxEventProcessorUnableToLock(processorName, lockException);
            return Collections.emptyList();
        }
    }

    protected abstract List<OutboxEvent> tryLoadLocking(Session var1, Set<Long> var2);

    private static class LockAllOutboxEventLoader
    extends OutboxEventLoader {
        private LockAllOutboxEventLoader() {
        }

        @Override
        protected List<OutboxEvent> tryLoadLocking(Session session, Set<Long> ids) {
            Query query = session.createQuery(OutboxEventLoader.LOAD_QUERY, OutboxEvent.class);
            query.setParameter("ids", ids);
            query.setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE));
            return query.getResultList();
        }
    }

    private static class SkipLockedOutboxEventLoader
    extends OutboxEventLoader {
        private SkipLockedOutboxEventLoader() {
        }

        @Override
        protected List<OutboxEvent> tryLoadLocking(Session session, Set<Long> ids) {
            Query query = session.createQuery(OutboxEventLoader.LOAD_QUERY, OutboxEvent.class);
            query.setParameter("ids", ids);
            query.setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE).setTimeOut(-2));
            return query.getResultList();
        }
    }
}

