/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class NetClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final NetClientAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> NetClientAttributesExtractor<REQUEST, RESPONSE> create(NetClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new NetClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private NetClientAttributesExtractor(NetClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String peerName = this.getter.peerName(request);
        Integer peerPort = this.getter.peerPort(request);
        if (peerName != null) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PEER_NAME, (Object)peerName);
            if (peerPort != null && peerPort > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PEER_PORT, (Object)peerPort);
            }
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_TRANSPORT, (Object)this.getter.transport(request, response));
        String peerName = this.getter.peerName(request);
        Integer peerPort = this.getter.peerPort(request);
        String sockPeerAddr = this.getter.sockPeerAddr(request, response);
        if (sockPeerAddr != null && !sockPeerAddr.equals(peerName)) {
            String sockPeerName;
            String sockFamily;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)sockPeerAddr);
            Integer sockPeerPort = this.getter.sockPeerPort(request, response);
            if (sockPeerPort != null && sockPeerPort > 0 && !sockPeerPort.equals(peerPort)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_PORT, (Object)sockPeerPort);
            }
            if ((sockFamily = this.getter.sockFamily(request, response)) != null && !"inet".equals(sockFamily)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_FAMILY, (Object)sockFamily);
            }
            if ((sockPeerName = this.getter.sockPeerName(request, response)) != null && !sockPeerName.equals(peerName)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_NAME, (Object)sockPeerName);
            }
        }
    }
}

