/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementUnorderedArrayEquivalence;

class AnalysisParameterEquivalenceRegistry {
    private static final JsonElementEquivalence DEFAULT_ELEMENT_EQUIVALENCE = new JsonElementEquivalence();
    private static final JsonElementEquivalence UNORDERED_ARRAY_EQUIVALENCE = new JsonElementUnorderedArrayEquivalence(DEFAULT_ELEMENT_EQUIVALENCE);
    private final Map<String, Map<String, JsonElementEquivalence>> equivalences;

    private AnalysisParameterEquivalenceRegistry(Map<String, Map<String, JsonElementEquivalence>> equivalences) {
        this.equivalences = equivalences;
    }

    public JsonElementEquivalence get(String type, String parameter) {
        Map<String, JsonElementEquivalence> mapForType = this.equivalences.get(type);
        JsonElementEquivalence result = mapForType == null ? null : mapForType.get(parameter);
        return result == null ? DEFAULT_ELEMENT_EQUIVALENCE : result;
    }

    public static class ParameterBuilder {
        private final TypeBuilder parent;
        private final String parameterName;

        private ParameterBuilder(TypeBuilder parent, String parameterName) {
            this.parent = parent;
            this.parameterName = parameterName;
        }

        public TypeBuilder unorderedArray() {
            this.parent.add(this.parameterName, UNORDERED_ARRAY_EQUIVALENCE);
            return this.parent;
        }
    }

    public static class TypeBuilder {
        private final Builder parent;
        private final Map<String, JsonElementEquivalence> equivalences;

        private TypeBuilder(Builder parent, Map<String, JsonElementEquivalence> equivalences) {
            this.parent = parent;
            this.equivalences = equivalences;
        }

        public ParameterBuilder param(String name) {
            return new ParameterBuilder(this, name);
        }

        private void add(String parameterName, JsonElementEquivalence equivalence) {
            this.equivalences.put(parameterName, equivalence);
        }

        public Builder end() {
            return this.parent;
        }
    }

    public static class Builder {
        private final Map<String, Map<String, JsonElementEquivalence>> equivalences = new HashMap<String, Map<String, JsonElementEquivalence>>();

        public TypeBuilder type(String name) {
            Map<String, JsonElementEquivalence> mapForType = this.equivalences.get(name);
            if (mapForType == null) {
                mapForType = new HashMap<String, JsonElementEquivalence>();
                this.equivalences.put(name, mapForType);
            }
            return new TypeBuilder(this, mapForType);
        }

        public AnalysisParameterEquivalenceRegistry build() {
            return new AnalysisParameterEquivalenceRegistry(this.equivalences);
        }
    }
}

