/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.security.SaslChallenge;
import org.apache.qpid.proton.amqp.security.SaslCode;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.amqp.security.SaslInit;
import org.apache.qpid.proton.amqp.security.SaslMechanisms;
import org.apache.qpid.proton.amqp.security.SaslOutcome;
import org.apache.qpid.proton.amqp.security.SaslResponse;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SaslListener;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.AmqpHeader;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.FrameWriter;
import org.apache.qpid.proton.engine.impl.PlainTransportWrapper;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.SaslFrameHandler;
import org.apache.qpid.proton.engine.impl.SaslFrameParser;
import org.apache.qpid.proton.engine.impl.SaslSniffer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;

public class SaslImpl
implements Sasl,
SaslFrameBody.SaslFrameBodyHandler<Void>,
SaslFrameHandler,
TransportLayer {
    private static final Logger _logger = Logger.getLogger(SaslImpl.class.getName());
    public static final byte SASL_FRAME_TYPE = 1;
    private static final String HEADER_DESCRIPTION = "SASL";
    private final DecoderImpl _decoder = new DecoderImpl();
    private final EncoderImpl _encoder = new EncoderImpl(this._decoder);
    private final TransportImpl _transport;
    private boolean _tail_closed = false;
    private boolean _head_closed = false;
    private final int _maxFrameSize;
    private final FrameWriter _frameWriter;
    private ByteBuffer _pending;
    private boolean _headerWritten;
    private Binary _challengeResponse;
    private SaslFrameParser _frameParser;
    private boolean _initReceived;
    private boolean _mechanismsSent;
    private boolean _initSent;
    private Sasl.SaslOutcome _outcome = Sasl.SaslOutcome.PN_SASL_NONE;
    private Sasl.SaslState _state = Sasl.SaslState.PN_SASL_IDLE;
    private String _hostname;
    private boolean _done;
    private Symbol[] _mechanisms;
    private Symbol _chosenMechanism;
    private Role _role;
    private boolean _allowSkip = true;
    private SaslListener _saslListener;

    SaslImpl(TransportImpl transport, int maxFrameSize) {
        this._transport = transport;
        this._maxFrameSize = maxFrameSize;
        AMQPDefinedTypes.registerAllTypes(this._decoder, this._encoder);
        this._frameParser = new SaslFrameParser(this, this._decoder, maxFrameSize, this._transport);
        this._frameWriter = new FrameWriter(this._encoder, maxFrameSize, 1, this._transport);
    }

    void fail() {
        if (this._role == null || this._role == Role.CLIENT) {
            this._role = Role.CLIENT;
            this._initSent = true;
        } else {
            this._initReceived = true;
        }
        this._done = true;
        this._outcome = Sasl.SaslOutcome.PN_SASL_SYS;
    }

    @Override
    public boolean isDone() {
        return this._done && (this._role == Role.CLIENT || this._initReceived);
    }

    private void process() {
        this.processHeader();
        if (this._role == Role.SERVER) {
            if (!this._mechanismsSent && this._mechanisms != null) {
                SaslMechanisms mechanisms = new SaslMechanisms();
                mechanisms.setSaslServerMechanisms(this._mechanisms);
                this.writeFrame(mechanisms);
                this._mechanismsSent = true;
                this._state = Sasl.SaslState.PN_SASL_STEP;
            }
            if (this.getState() == Sasl.SaslState.PN_SASL_STEP && this.getChallengeResponse() != null) {
                SaslChallenge challenge = new SaslChallenge();
                challenge.setChallenge(this.getChallengeResponse());
                this.writeFrame(challenge);
                this.setChallengeResponse(null);
            }
            if (this._done) {
                SaslOutcome outcome = new SaslOutcome();
                outcome.setCode(SaslCode.values()[this._outcome.getCode()]);
                if (this._outcome == PN_SASL_OK) {
                    outcome.setAdditionalData(this.getChallengeResponse());
                }
                this.writeFrame(outcome);
                this.setChallengeResponse(null);
            }
        } else if (this._role == Role.CLIENT) {
            if (this.getState() == Sasl.SaslState.PN_SASL_IDLE && this._chosenMechanism != null) {
                this.processInit();
                this._state = Sasl.SaslState.PN_SASL_STEP;
                if (this._outcome != Sasl.SaslOutcome.PN_SASL_NONE) {
                    this._state = this.classifyStateFromOutcome(this._outcome);
                }
            }
            if (this.getState() == Sasl.SaslState.PN_SASL_STEP && this.getChallengeResponse() != null) {
                this.processResponse();
            }
        }
    }

    private void writeFrame(SaslFrameBody frameBody) {
        this._frameWriter.writeFrame(frameBody);
    }

    @Override
    public final int recv(byte[] bytes, int offset, int size) {
        if (this._pending == null) {
            return -1;
        }
        int written = ByteBufferUtils.pourBufferToArray(this._pending, bytes, offset, size);
        if (!this._pending.hasRemaining()) {
            this._pending = null;
        }
        return written;
    }

    @Override
    public final int send(byte[] bytes, int offset, int size) {
        byte[] data = new byte[size];
        System.arraycopy(bytes, offset, data, 0, size);
        this.setChallengeResponse(new Binary(data));
        return size;
    }

    final int processHeader() {
        if (!this._headerWritten) {
            this.logHeader();
            this._frameWriter.writeHeader(AmqpHeader.SASL_HEADER);
            this._headerWritten = true;
            return AmqpHeader.SASL_HEADER.length;
        }
        return 0;
    }

    private void logHeader() {
        if (this._transport.isFrameTracingEnabled()) {
            this._transport.log(TransportImpl.OUTGOING, HEADER_DESCRIPTION);
            ProtocolTracer tracer = this._transport.getProtocolTracer();
            if (tracer != null) {
                tracer.sentHeader(HEADER_DESCRIPTION);
            }
        }
    }

    @Override
    public int pending() {
        return this._pending == null ? 0 : this._pending.remaining();
    }

    void setPending(ByteBuffer pending) {
        this._pending = pending;
    }

    @Override
    public Sasl.SaslState getState() {
        return this._state;
    }

    final Binary getChallengeResponse() {
        return this._challengeResponse;
    }

    final void setChallengeResponse(Binary challengeResponse) {
        this._challengeResponse = challengeResponse;
    }

    @Override
    public void setMechanisms(String ... mechanisms) {
        if (mechanisms != null) {
            this._mechanisms = new Symbol[mechanisms.length];
            for (int i = 0; i < mechanisms.length; ++i) {
                this._mechanisms[i] = Symbol.valueOf(mechanisms[i]);
            }
        }
        if (this._role == Role.CLIENT) {
            assert (mechanisms != null);
            assert (mechanisms.length == 1);
            this._chosenMechanism = Symbol.valueOf(mechanisms[0]);
        }
    }

    @Override
    public String[] getRemoteMechanisms() {
        if (this._role == Role.SERVER) {
            String[] stringArray;
            if (this._chosenMechanism == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._chosenMechanism.toString();
            }
            return stringArray;
        }
        if (this._role == Role.CLIENT) {
            if (this._mechanisms == null) {
                return new String[0];
            }
            String[] remoteMechanisms = new String[this._mechanisms.length];
            for (int i = 0; i < this._mechanisms.length; ++i) {
                remoteMechanisms[i] = this._mechanisms[i].toString();
            }
            return remoteMechanisms;
        }
        throw new IllegalStateException();
    }

    public void setMechanism(Symbol mechanism) {
        this._chosenMechanism = mechanism;
    }

    public Symbol getChosenMechanism() {
        return this._chosenMechanism;
    }

    public void setResponse(Binary initialResponse) {
        this.setPending(initialResponse.asByteBuffer());
    }

    @Override
    public void handle(SaslFrameBody frameBody, Binary payload) {
        this._transport.log(TransportImpl.INCOMING, frameBody);
        ProtocolTracer tracer = this._transport.getProtocolTracer();
        if (tracer != null) {
            tracer.receivedSaslBody(frameBody);
        }
        frameBody.invoke(this, payload, null);
    }

    @Override
    public void handleInit(SaslInit saslInit, Binary payload, Void context) {
        if (this._role == null) {
            this.server();
        }
        this.checkRole(Role.SERVER);
        this._hostname = saslInit.getHostname();
        this._chosenMechanism = saslInit.getMechanism();
        this._initReceived = true;
        if (saslInit.getInitialResponse() != null) {
            this.setPending(saslInit.getInitialResponse().asByteBuffer());
        }
        if (this._saslListener != null) {
            this._saslListener.onSaslInit(this, this._transport);
        }
    }

    @Override
    public void handleResponse(SaslResponse saslResponse, Binary payload, Void context) {
        this.checkRole(Role.SERVER);
        this.setPending(saslResponse.getResponse() == null ? null : saslResponse.getResponse().asByteBuffer());
        if (this._saslListener != null) {
            this._saslListener.onSaslResponse(this, this._transport);
        }
    }

    @Override
    public void done(Sasl.SaslOutcome outcome) {
        this.checkRole(Role.SERVER);
        this._outcome = outcome;
        this._done = true;
        this._state = this.classifyStateFromOutcome(outcome);
        _logger.fine("SASL negotiation done: " + this);
    }

    private void checkRole(Role role) {
        if (role != this._role) {
            throw new IllegalStateException("Role is " + (Object)((Object)this._role) + " but should be " + (Object)((Object)role));
        }
    }

    @Override
    public void handleMechanisms(SaslMechanisms saslMechanisms, Binary payload, Void context) {
        if (this._role == null) {
            this.client();
        }
        this.checkRole(Role.CLIENT);
        this._mechanisms = saslMechanisms.getSaslServerMechanisms();
        if (this._saslListener != null) {
            this._saslListener.onSaslMechanisms(this, this._transport);
        }
    }

    @Override
    public void handleChallenge(SaslChallenge saslChallenge, Binary payload, Void context) {
        this.checkRole(Role.CLIENT);
        this.setPending(saslChallenge.getChallenge() == null ? null : saslChallenge.getChallenge().asByteBuffer());
        if (this._saslListener != null) {
            this._saslListener.onSaslChallenge(this, this._transport);
        }
    }

    @Override
    public void handleOutcome(SaslOutcome saslOutcome, Binary payload, Void context) {
        this.checkRole(Role.CLIENT);
        for (Sasl.SaslOutcome outcome : Sasl.SaslOutcome.values()) {
            this.setPending(saslOutcome.getAdditionalData() == null ? null : saslOutcome.getAdditionalData().asByteBuffer());
            if (outcome.getCode() != saslOutcome.getCode().ordinal()) continue;
            this._outcome = outcome;
            if (this._state == Sasl.SaslState.PN_SASL_IDLE) break;
            this._state = this.classifyStateFromOutcome(outcome);
            break;
        }
        this._done = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Handled outcome: " + this);
        }
        if (this._saslListener != null) {
            this._saslListener.onSaslOutcome(this, this._transport);
        }
    }

    private Sasl.SaslState classifyStateFromOutcome(Sasl.SaslOutcome outcome) {
        return outcome == Sasl.SaslOutcome.PN_SASL_OK ? Sasl.SaslState.PN_SASL_PASS : Sasl.SaslState.PN_SASL_FAIL;
    }

    private void processResponse() {
        SaslResponse response = new SaslResponse();
        response.setResponse(this.getChallengeResponse());
        this.setChallengeResponse(null);
        this.writeFrame(response);
    }

    private void processInit() {
        SaslInit init = new SaslInit();
        init.setHostname(this._hostname);
        init.setMechanism(this._chosenMechanism);
        if (this.getChallengeResponse() != null) {
            init.setInitialResponse(this.getChallengeResponse());
            this.setChallengeResponse(null);
        }
        this._initSent = true;
        this.writeFrame(init);
    }

    @Override
    public void plain(String username, String password) {
        this.client();
        this._chosenMechanism = Symbol.valueOf("PLAIN");
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(usernameBytes, 0, data, 1, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + usernameBytes.length, passwordBytes.length);
        this.setChallengeResponse(new Binary(data));
    }

    @Override
    public Sasl.SaslOutcome getOutcome() {
        return this._outcome;
    }

    @Override
    public void client() {
        this._role = Role.CLIENT;
        if (this._mechanisms != null) {
            assert (this._mechanisms.length == 1);
            this._chosenMechanism = this._mechanisms[0];
        }
    }

    @Override
    public void server() {
        this._role = Role.SERVER;
    }

    @Override
    public void allowSkip(boolean allowSkip) {
        this._allowSkip = allowSkip;
    }

    @Override
    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new SaslSniffer(new SwitchingSaslTransportWrapper(input, output), new PlainTransportWrapper(output, input)){

            @Override
            protected boolean isDeterminationMade() {
                if (SaslImpl.this._role == Role.SERVER && SaslImpl.this._allowSkip) {
                    return super.isDeterminationMade();
                }
                this._selectedTransportWrapper = this._wrapper1;
                return true;
            }
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SaslImpl [_outcome=").append((Object)this._outcome).append(", state=").append((Object)this._state).append(", done=").append(this._done).append(", role=").append((Object)this._role).append("]");
        return builder.toString();
    }

    @Override
    public String getHostname() {
        if (this._role != null) {
            this.checkRole(Role.SERVER);
        }
        return this._hostname;
    }

    @Override
    public void setRemoteHostname(String hostname) {
        if (this._role != null) {
            this.checkRole(Role.CLIENT);
        }
        this._hostname = hostname;
    }

    @Override
    public void setListener(SaslListener saslListener) {
        this._saslListener = saslListener;
    }

    static enum Role {
        CLIENT,
        SERVER;

    }

    private class SwitchingSaslTransportWrapper
    implements TransportWrapper {
        private final TransportInput _underlyingInput;
        private final TransportOutput _underlyingOutput;
        private TransportInput currentInput;
        private TransportOutput currentOutput;

        private SwitchingSaslTransportWrapper(TransportInput input, TransportOutput output) {
            this._underlyingInput = input;
            this._underlyingOutput = output;
            SaslTransportWrapper saslProcessor = new SaslTransportWrapper(this, input, output);
            this.currentInput = saslProcessor;
            this.currentOutput = saslProcessor;
        }

        @Override
        public int capacity() {
            return this.currentInput.capacity();
        }

        @Override
        public int position() {
            return this.currentInput.position();
        }

        @Override
        public ByteBuffer tail() throws TransportException {
            return this.currentInput.tail();
        }

        @Override
        public void process() throws TransportException {
            this.currentInput.process();
        }

        @Override
        public void close_tail() {
            this.currentInput.close_tail();
        }

        @Override
        public int pending() {
            return this.currentOutput.pending();
        }

        @Override
        public ByteBuffer head() {
            return this.currentOutput.head();
        }

        @Override
        public void pop(int bytes) {
            this.currentOutput.pop(bytes);
        }

        @Override
        public void close_head() {
            this.currentOutput.close_head();
        }

        void switchToNextInput() {
            this.currentInput = this._underlyingInput;
        }

        void switchToNextOutput() {
            this.currentOutput = this._underlyingOutput;
        }
    }

    private class SaslTransportWrapper
    implements TransportWrapper {
        private final TransportInput _underlyingInput;
        private final TransportOutput _underlyingOutput;
        private boolean _outputComplete;
        private final ByteBuffer _outputBuffer;
        private final ByteBuffer _inputBuffer;
        private final ByteBuffer _head;
        private final SwitchingSaslTransportWrapper _parent;

        private SaslTransportWrapper(SwitchingSaslTransportWrapper parent, TransportInput input, TransportOutput output) {
            this._underlyingInput = input;
            this._underlyingOutput = output;
            this._inputBuffer = ByteBufferUtils.newWriteableBuffer(SaslImpl.this._maxFrameSize);
            this._outputBuffer = ByteBufferUtils.newWriteableBuffer(SaslImpl.this._maxFrameSize);
            this._parent = parent;
            this._head = SaslImpl.this._transport.isUseReadOnlyOutputBuffer() ? this._outputBuffer.asReadOnlyBuffer() : this._outputBuffer.duplicate();
            this._head.limit(0);
        }

        private void fillOutputBuffer() {
            if (this.isOutputInSaslMode()) {
                this.writeSaslOutput();
                if (SaslImpl.this._done) {
                    this._outputComplete = true;
                }
            }
        }

        private boolean isInputInSaslMode() {
            return SaslImpl.this._role == null || SaslImpl.this._role == Role.CLIENT && !SaslImpl.this._done || SaslImpl.this._role == Role.SERVER && (!SaslImpl.this._initReceived || !SaslImpl.this._done);
        }

        private boolean isOutputInSaslMode() {
            return SaslImpl.this._role == null || SaslImpl.this._role == Role.CLIENT && (!SaslImpl.this._done || !SaslImpl.this._initSent) || SaslImpl.this._role == Role.SERVER && !this._outputComplete;
        }

        @Override
        public int capacity() {
            if (SaslImpl.this._tail_closed) {
                return -1;
            }
            if (this.isInputInSaslMode()) {
                return this._inputBuffer.remaining();
            }
            return this._underlyingInput.capacity();
        }

        @Override
        public int position() {
            if (SaslImpl.this._tail_closed) {
                return -1;
            }
            if (this.isInputInSaslMode()) {
                return this._inputBuffer.position();
            }
            return this._underlyingInput.position();
        }

        @Override
        public ByteBuffer tail() {
            if (!this.isInputInSaslMode()) {
                return this._underlyingInput.tail();
            }
            return this._inputBuffer;
        }

        @Override
        public void process() throws TransportException {
            this._inputBuffer.flip();
            try {
                this.reallyProcessInput();
            }
            finally {
                this._inputBuffer.compact();
            }
        }

        @Override
        public void close_tail() {
            SaslImpl.this._tail_closed = true;
            if (this.isInputInSaslMode()) {
                SaslImpl.this._head_closed = true;
                this._underlyingInput.close_tail();
            } else {
                this._underlyingInput.close_tail();
            }
        }

        private void reallyProcessInput() throws TransportException {
            if (this.isInputInSaslMode()) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.log(Level.FINER, SaslImpl.this + " about to call input.");
                }
                SaslImpl.this._frameParser.input(this._inputBuffer);
            }
            if (!this.isInputInSaslMode()) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.log(Level.FINER, SaslImpl.this + " about to call plain input");
                }
                if (this._inputBuffer.hasRemaining()) {
                    int bytes = ByteBufferUtils.pourAll(this._inputBuffer, this._underlyingInput);
                    if (bytes == -1) {
                        SaslImpl.this._tail_closed = true;
                    }
                    if (!this._inputBuffer.hasRemaining()) {
                        this._parent.switchToNextInput();
                    }
                } else {
                    this._parent.switchToNextInput();
                }
                this._underlyingInput.process();
            }
        }

        @Override
        public int pending() {
            if (this.isOutputInSaslMode() || this._outputBuffer.position() != 0) {
                this.fillOutputBuffer();
                this._head.limit(this._outputBuffer.position());
                if (SaslImpl.this._head_closed && this._outputBuffer.position() == 0) {
                    return -1;
                }
                return this._outputBuffer.position();
            }
            this._parent.switchToNextOutput();
            return this._underlyingOutput.pending();
        }

        @Override
        public ByteBuffer head() {
            if (this.isOutputInSaslMode() || this._outputBuffer.position() != 0) {
                this.pending();
                return this._head;
            }
            this._parent.switchToNextOutput();
            return this._underlyingOutput.head();
        }

        @Override
        public void pop(int bytes) {
            if (this.isOutputInSaslMode() || this._outputBuffer.position() != 0) {
                this._outputBuffer.flip();
                this._outputBuffer.position(bytes);
                this._outputBuffer.compact();
                this._head.position(0);
                this._head.limit(this._outputBuffer.position());
            } else {
                this._parent.switchToNextOutput();
                this._underlyingOutput.pop(bytes);
            }
        }

        @Override
        public void close_head() {
            this._parent.switchToNextOutput();
            this._underlyingOutput.close_head();
        }

        private void writeSaslOutput() {
            SaslImpl.this.process();
            SaslImpl.this._frameWriter.readBytes(this._outputBuffer);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "Finished writing SASL output. Output Buffer : " + this._outputBuffer);
            }
        }
    }
}

