/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.transformer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.wildfly.galleon.plugin.transformer.BataviaTransformer;
import org.wildfly.galleon.plugin.transformer.TransformedArtifact;
import org.wildfly.galleon.plugin.transformer.Utils;

public class JakartaTransformer {
    public static final String TRANSFORM_ARTIFACTS = "jakarta.transform.artifacts";
    public static final String TRANSFORM_CONFIGS_DIR = "jakarta.transform.configs.dir";
    public static final String TRANSFORM_VERBOSE = "jakarta.transform.verbose";
    private static final LogHandler DEFAULT_LOG_HANDLER = new LogHandler(){

        @Override
        public void print(String format, Object ... args) {
            System.out.println(String.format(format, args));
        }
    };
    private static final String CONFIGS_DIR_PARAM = "--configs-dir=";
    private static final String VERBOSE_PARAM = "--verbose";
    private static final String HELP_PARAM = "--help";

    public static void main(String[] args) throws Exception {
        String configsDir = null;
        boolean verbose = false;
        String source = null;
        String target = null;
        for (String arg : args) {
            if (arg.equals(HELP_PARAM)) {
                JakartaTransformer.printHelp();
                return;
            }
            if (arg.startsWith(CONFIGS_DIR_PARAM)) {
                configsDir = arg.substring(CONFIGS_DIR_PARAM.length());
                continue;
            }
            if (arg.equals(VERBOSE_PARAM)) {
                verbose = true;
                continue;
            }
            if (source == null) {
                source = arg;
                Path sourcePath = Paths.get(source, new String[0]);
                if (!Files.notExists(sourcePath, new LinkOption[0])) continue;
                throw new Exception("Source artifact " + source + " doesn't exist.");
            }
            if (target == null) {
                target = arg;
                Path targetPath = Paths.get(target, new String[0]);
                if (!Files.exists(targetPath, new LinkOption[0])) continue;
                Files.delete(targetPath);
                continue;
            }
            throw new Exception("Invalid argument " + arg);
        }
        if (source == null || target == null) {
            throw new Exception("Source and target artifact must be set.");
        }
        boolean ret = BataviaTransformer.transform(configsDir, source, target, verbose);
        if (ret) {
            System.out.println("Artifact has been transformed.");
        } else {
            System.out.println("No transformation occured.");
        }
    }

    private static void printHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("WildFly Galleon EE9 transformer usage:\n");
        builder.append("java -jar <transformer jar> <source file> <target file> [ARGUMENTS]\n");
        builder.append("If the target file already exists, it will be first deleted.");
        builder.append("Arguments:\n");
        builder.append("  --help : print this help\n");
        builder.append("  --verbose : print transformation traces\n");
        builder.append("  --configs-dir=<rules dir> : path to a directory containing transformation rules\n");
        builder.append("To redirect traces into a file: java -jar <transformer jar> <source> <target> --verbose &> traces.txt\n");
        System.out.println(builder.toString());
    }

    public static InputStream transform(Path configsDir, InputStream in, String name, boolean verbose, LogHandler log) throws IOException {
        int size;
        if (log == null) {
            log = DEFAULT_LOG_HANDLER;
        }
        if (!(((String)name).endsWith(".war") || ((String)name).endsWith(".ear") || ((String)name).endsWith(".rar") || ((String)name).endsWith(".jar") || ((String)name).endsWith(".xml"))) {
            name = (String)name + ".war";
        }
        Path dir = Files.createTempDirectory("jakarta-transform", new FileAttribute[0]);
        Path src = dir.resolve("jakartaee-" + (String)name);
        Path target = dir.resolve((String)name);
        FileOutputStream out = new FileOutputStream(src.toFile());
        byte[] buffer = new byte[1024];
        while ((size = in.read(buffer)) != -1) {
            out.write(buffer, 0, size);
        }
        out.close();
        BataviaTransformer.transform(configsDir, src, target, verbose, log);
        return new WrappedInputStream(target.toFile(), dir);
    }

    public static TransformedArtifact transform(Path configsDir, Path src, Path target, boolean verbose, LogHandler log) throws IOException {
        if (log == null) {
            log = DEFAULT_LOG_HANDLER;
        }
        Path originalSrc = src;
        Path actualTarget = null;
        Path safeCopy = null;
        boolean failed = false;
        boolean isExploded = false;
        if (Files.isDirectory(src, new LinkOption[0])) {
            isExploded = true;
            if (target.equals(src)) {
                safeCopy = target.getParent().resolve("jakartaee-" + target.getFileName().toString());
                log.print("Transformation target is equal to src, moving src artifact directory to %s", safeCopy);
                Utils.copy(src, safeCopy);
                Utils.recursiveDelete(src);
                src = safeCopy;
            }
            actualTarget = target;
        } else if (Files.isDirectory(target, new LinkOption[0])) {
            actualTarget = target.resolve(src.getFileName());
        } else {
            if (src.equals(target)) {
                safeCopy = target.getParent().resolve("jakartaee-" + target.getFileName().toString());
                log.print("Transformation target is equal to src, moving src artifact to %s", safeCopy);
                if (Files.exists(safeCopy, new LinkOption[0])) {
                    Files.delete(safeCopy);
                }
                Files.copy(src, safeCopy, new CopyOption[0]);
                Files.delete(src);
                src = safeCopy;
            }
            actualTarget = target;
        }
        if (Files.exists(actualTarget, new LinkOption[0])) {
            throw new IOException("Transformation target " + actualTarget + " already exist");
        }
        try {
            TransformedArtifact transformedArtifact = BataviaTransformer.transform(configsDir, src, actualTarget, verbose, log);
            return transformedArtifact;
        }
        catch (Throwable ex) {
            failed = true;
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
        finally {
            if (failed && safeCopy != null) {
                log.print("Exception occured, reverting original src artifact", new Object[0]);
                if (isExploded) {
                    Utils.copy(safeCopy, originalSrc);
                } else {
                    Files.copy(safeCopy, originalSrc, new CopyOption[0]);
                }
            }
            if (safeCopy != null) {
                if (isExploded) {
                    Utils.recursiveDelete(safeCopy);
                } else {
                    Files.delete(safeCopy);
                }
            }
        }
    }

    public static interface LogHandler {
        public void print(String var1, Object ... var2);
    }

    static class WrappedInputStream
    extends FileInputStream {
        private final Path dir;

        public WrappedInputStream(File file, Path dir) throws FileNotFoundException {
            super(file);
            this.dir = dir;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Utils.recursiveDelete(this.dir);
        }
    }
}

