/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.health;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.KafkaAdmin;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.health.BaseHealth;
import io.smallrye.reactive.messaging.kafka.impl.KafkaAdminHelper;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSource;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.Metric;

public class KafkaSourceHealth
extends BaseHealth {
    private final KafkaAdmin admin;
    private final KafkaSource<?, ?> source;
    private final ReactiveKafkaConsumer<?, ?> client;
    private final Duration adminClientTimeout;
    private Metric metric;

    public KafkaSourceHealth(KafkaSource<?, ?> source, KafkaConnectorIncomingConfiguration config, ReactiveKafkaConsumer<?, ?> client) {
        super(config.getChannel());
        this.adminClientTimeout = Duration.ofMillis(config.getHealthReadinessTimeout().orElse(config.getHealthTopicVerificationTimeout()));
        this.source = source;
        this.client = client;
        if (config.getHealthReadinessTopicVerification().orElse(config.getHealthTopicVerificationEnabled()).booleanValue()) {
            HashMap<String, Object> adminConfiguration = new HashMap<String, Object>(client.configuration());
            this.admin = KafkaAdminHelper.createAdminClient(adminConfiguration, config.getChannel(), true);
        } else {
            this.admin = null;
        }
    }

    protected synchronized Metric getMetric() {
        Consumer<?, ?> consumer;
        if (this.metric == null && (consumer = this.client.unwrap()) != null) {
            this.metric = this.getMetric(consumer.metrics());
        }
        return this.metric;
    }

    @Override
    protected void metricsBasedStartupCheck(HealthReport.HealthReportBuilder builder) {
        Metric metric = this.getMetric();
        if (metric != null) {
            boolean connected = (Double)metric.metricValue() >= 1.0;
            boolean hasSubscribers = this.source.hasSubscribers();
            if (connected) {
                builder.add(this.channel, true);
            } else if (!hasSubscribers) {
                builder.add(this.channel, true, "no subscription yet, so no connection to the Kafka broker yet");
            } else {
                builder.add(this.channel, false);
            }
        } else {
            builder.add(this.channel, true).build();
        }
    }

    @Override
    protected void metricsBasedReadinessCheck(HealthReport.HealthReportBuilder builder) {
        this.metricsBasedStartupCheck(builder);
    }

    @Override
    protected void clientBasedStartupCheck(HealthReport.HealthReportBuilder builder) {
        try {
            this.admin.listTopics().await().atMost(this.adminClientTimeout);
            builder.add(this.channel, true);
        }
        catch (Exception failed) {
            builder.add(this.channel, false, "Failed to get response from broker for channel " + this.channel + " : " + failed);
        }
    }

    @Override
    protected void clientBasedReadinessCheck(HealthReport.HealthReportBuilder builder) {
        block5: {
            if (this.source.hasSubscribers()) {
                try {
                    Set partitions = (Set)this.client.getAssignments().await().atMost(this.adminClientTimeout);
                    if (partitions.isEmpty()) {
                        builder.add(this.channel, false, "No partition assignments for channel " + this.channel);
                        break block5;
                    }
                    builder.add(this.channel, true);
                }
                catch (Exception failed) {
                    builder.add(this.channel, false, "No response from broker for channel " + this.channel + " : " + failed);
                }
            } else {
                builder.add(this.channel, true, "no subscription yet, so no partition assignments");
            }
        }
    }

    @Override
    public KafkaAdmin getAdmin() {
        return this.admin;
    }
}

