/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.coordinator;

import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ReaperElementManager {
    private final ArrayList<ReaperElement> elementsOrderedByTimeout = new ArrayList();
    private final ConcurrentHashMap<ReaperElement, ReaperElement> pendingInsertions = new ConcurrentHashMap();

    public synchronized ReaperElement getFirst() {
        this.flushPending();
        if (this.elementsOrderedByTimeout.isEmpty()) {
            return null;
        }
        return this.elementsOrderedByTimeout.get(0);
    }

    public void add(ReaperElement reaperElement) throws IllegalStateException {
        if (this.pendingInsertions.putIfAbsent(reaperElement, reaperElement) != null) {
            throw new IllegalStateException();
        }
    }

    public synchronized long reorder(ReaperElement reaperElement, long delayMillis) {
        this.removeSorted(reaperElement);
        reaperElement.setNextCheckAbsoluteMillis(System.currentTimeMillis() + delayMillis);
        this.insertSorted(reaperElement);
        return this.getFirst().getNextCheckAbsoluteMillis();
    }

    public synchronized int size() {
        return this.elementsOrderedByTimeout.size() + this.pendingInsertions.size();
    }

    public synchronized boolean isEmpty() {
        return this.elementsOrderedByTimeout.isEmpty() && this.pendingInsertions.isEmpty();
    }

    public synchronized void setAllTimeoutsToZero() {
        this.flushPending();
        for (ReaperElement reaperElement : this.elementsOrderedByTimeout) {
            reaperElement.setNextCheckAbsoluteMillis(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ReaperElement reaperElement) {
        if (this.pendingInsertions.remove(reaperElement) != null) {
            return;
        }
        ReaperElementManager reaperElementManager = this;
        synchronized (reaperElementManager) {
            this.removeSorted(reaperElement);
        }
    }

    private void removeSorted(ReaperElement reaperElement) {
        int location = Collections.binarySearch(this.elementsOrderedByTimeout, reaperElement);
        if (location >= 0) {
            this.elementsOrderedByTimeout.remove(location);
        }
    }

    private void insertSorted(ReaperElement reaperElement) {
        int location = Collections.binarySearch(this.elementsOrderedByTimeout, reaperElement);
        if (location >= 0) {
            throw new IllegalStateException();
        }
        int insertionPoint = -(location + 1);
        this.elementsOrderedByTimeout.add(insertionPoint, reaperElement);
    }

    private void flushPending() {
        Set<Map.Entry<ReaperElement, ReaperElement>> entrySet = this.pendingInsertions.entrySet();
        if (entrySet != null) {
            for (Map.Entry<ReaperElement, ReaperElement> entry : entrySet) {
                ReaperElement element = entry.getValue();
                if (!entrySet.remove(entry)) continue;
                this.insertSorted(element);
            }
        }
    }
}

