/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.slot;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.objectstore.slot.BackingSlots;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStoreEnvironmentBean;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.zip.CRC32;

public class MappedDiskSlots
implements BackingSlots {
    private SlotStoreEnvironmentBean config;
    private int slotSize;
    private FileChannel[] fileChannels;
    private MappedByteBuffer[] slots;

    @Override
    public synchronized void init(SlotStoreEnvironmentBean config) throws IOException {
        if (this.config != null) {
            throw new IllegalStateException("already initialized");
        }
        this.config = config;
        this.slotSize = config.getBytesPerSlot() + 8;
        File storeDir = new File(config.getStoreDir());
        if (!storeDir.exists() && !storeDir.mkdirs()) {
            throw new IOException(tsLogger.i18NLogger.get_dir_create_failed(storeDir.getCanonicalPath()));
        }
        this.fileChannels = new FileChannel[config.getNumberOfSlots()];
        this.slots = new MappedByteBuffer[config.getNumberOfSlots()];
        for (int i = 0; i < this.slots.length; ++i) {
            File file = new File(storeDir, "slot." + i);
            this.fileChannels[i] = (FileChannel)Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE), new FileAttribute[0]);
            this.slots[i] = this.fileChannels[i].map(FileChannel.MapMode.READ_WRITE, 0L, this.slotSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int slot, byte[] data, boolean sync) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer = this.slots[slot];
        synchronized (mappedByteBuffer2) {
            mappedByteBuffer.position(0);
            mappedByteBuffer.putInt(data.length);
            mappedByteBuffer.put(data);
            mappedByteBuffer.putInt(this.checksum(data));
            if (sync) {
                mappedByteBuffer.force();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(int slot) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer = this.slots[slot];
        synchronized (mappedByteBuffer2) {
            mappedByteBuffer.position(0);
            if (mappedByteBuffer.remaining() < 8) {
                return null;
            }
            try {
                int dataLength = mappedByteBuffer.getInt();
                byte[] data = new byte[dataLength];
                mappedByteBuffer.get(data);
                int expectedChecksum = mappedByteBuffer.getInt();
                if (expectedChecksum == this.checksum(data)) {
                    return data;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    @Override
    public void clear(int slot, boolean sync) throws IOException {
        this.write(slot, new byte[0], sync);
    }

    private int checksum(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data, 0, data.length);
        int checksum = (int)crc32.getValue();
        return checksum;
    }
}

