/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventAndPredicate;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventFinder;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventFinderProvider;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventPredicate;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalJaxbMappingProducer;

public final class DefaultOutboxEventFinder
implements OutboxEventFinder {
    private static OutboxEventAndPredicate basePredicateFilter = OutboxEventAndPredicate.of(new ProcessAfterFilter(), new ProcessPendingFilter());
    private final String queryString;
    private final Optional<OutboxEventPredicate> predicate;

    public static String createQueryString(Optional<OutboxEventPredicate> predicate) {
        OutboxEventAndPredicate combined = predicate.isPresent() ? OutboxEventAndPredicate.of(predicate.get(), basePredicateFilter) : basePredicateFilter;
        return "select e from " + OutboxPollingOutboxEventAdditionalJaxbMappingProducer.ENTITY_NAME + " e where " + combined.queryPart("e") + " order by e.id";
    }

    public static Query<OutboxEvent> createQuery(Session session, int maxResults, String queryString, Optional<OutboxEventPredicate> predicate) {
        Query query = session.createQuery(queryString, OutboxEvent.class);
        if (predicate.isPresent()) {
            predicate.get().setParams((Query<OutboxEvent>)query);
        }
        basePredicateFilter.setParams((Query<OutboxEvent>)query);
        query.setMaxResults(maxResults);
        return query;
    }

    public DefaultOutboxEventFinder(Optional<OutboxEventPredicate> predicate) {
        this.queryString = DefaultOutboxEventFinder.createQueryString(predicate);
        this.predicate = predicate;
    }

    @Override
    public List<OutboxEvent> findOutboxEvents(Session session, int maxResults) {
        return DefaultOutboxEventFinder.createQuery(session, maxResults, this.queryString, this.predicate).list();
    }

    private static class ProcessPendingFilter
    implements OutboxEventPredicate {
        private ProcessPendingFilter() {
        }

        @Override
        public String queryPart(String eventAlias) {
            return eventAlias + ".status = :status";
        }

        @Override
        public void setParams(Query<OutboxEvent> query) {
            query.setParameter("status", (Object)OutboxEvent.Status.PENDING);
        }
    }

    private static class ProcessAfterFilter
    implements OutboxEventPredicate {
        private ProcessAfterFilter() {
        }

        @Override
        public String queryPart(String eventAlias) {
            return eventAlias + ".processAfter is null or " + eventAlias + ".processAfter < :now";
        }

        @Override
        public void setParams(Query<OutboxEvent> query) {
            query.setParameter("now", (Object)Instant.now());
        }
    }

    public static final class Provider
    implements OutboxEventFinderProvider {
        @Override
        public DefaultOutboxEventFinder create(Optional<OutboxEventPredicate> predicate) {
            return new DefaultOutboxEventFinder(predicate);
        }
    }
}

