/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.type.spi.TypeBootstrapContext;

@Internal
public class TypeBeanInstanceProducer
implements BeanInstanceProducer,
TypeBootstrapContext {
    private final ConfigurationService configurationService;

    public TypeBeanInstanceProducer(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public <B> B produceBeanInstance(Class<B> beanType) {
        try {
            Constructor<B> bootstrapContextAwareTypeConstructor = ReflectHelper.getConstructor(beanType, TypeBootstrapContext.class);
            if (bootstrapContextAwareTypeConstructor != null) {
                return bootstrapContextAwareTypeConstructor.newInstance(this);
            }
            return beanType.newInstance();
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate Type: " + beanType.getName(), e);
        }
    }

    @Override
    public <B> B produceBeanInstance(String name, Class<B> beanType) {
        return this.produceBeanInstance(beanType);
    }

    @Override
    public Map<String, Object> getConfigurationSettings() {
        return this.configurationService.getSettings();
    }
}

