/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverDirtinessFilterNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverMultiNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoRuntimePathsBuildingHelper;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.util.common.AssertionFailure;

abstract class AbstractPojoImplicitReindexingResolverNodeBuilder<T> {
    final PojoImplicitReindexingResolverBuildingHelper buildingHelper;
    private boolean frozen = false;
    private final Set<PojoModelPathValueNode> dirtyPathsTriggeringReindexingIncludingNestedNodes = new LinkedHashSet<PojoModelPathValueNode>();

    AbstractPojoImplicitReindexingResolverNodeBuilder(PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this.buildingHelper = buildingHelper;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getModelPath() + "]";
    }

    abstract BoundPojoModelPath getModelPath();

    abstract void closeOnFailure();

    final void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.onFreeze(this.dirtyPathsTriggeringReindexingIncludingNestedNodes);
        }
    }

    abstract void onFreeze(Set<PojoModelPathValueNode> var1);

    final void checkNotFrozen() {
        if (this.frozen) {
            throw new AssertionFailure("A mutating method was called on " + this + " after it was frozen.");
        }
    }

    final void checkFrozen() {
        if (!this.frozen) {
            throw new AssertionFailure("A method was called on " + this + " before it was frozen, but a preliminary freeze is required.");
        }
    }

    final Set<PojoModelPathValueNode> getDirtyPathsTriggeringReindexingIncludingNestedNodes() {
        this.checkFrozen();
        return this.dirtyPathsTriggeringReindexingIncludingNestedNodes;
    }

    final Optional<PojoImplicitReindexingResolverNode<T>> build(PojoRuntimePathsBuildingHelper pathsBuildingHelper, Set<PojoModelPathValueNode> allPotentialDirtyPaths) {
        Optional<PojoImplicitReindexingResolverNode<T>> result;
        this.freeze();
        Set<PojoModelPathValueNode> immutableDirtyPathsAcceptedByFilter = this.getDirtyPathsTriggeringReindexingIncludingNestedNodes();
        if (allPotentialDirtyPaths == null || !immutableDirtyPathsAcceptedByFilter.containsAll(allPotentialDirtyPaths)) {
            result = this.doBuild(pathsBuildingHelper, immutableDirtyPathsAcceptedByFilter);
            if (result.isPresent()) {
                result = Optional.of(this.wrapWithFilter(result.get(), pathsBuildingHelper, immutableDirtyPathsAcceptedByFilter));
            }
        } else {
            result = this.doBuild(pathsBuildingHelper, allPotentialDirtyPaths);
        }
        if (!result.isPresent()) {
            this.closeOnFailure();
        }
        return result;
    }

    abstract Optional<PojoImplicitReindexingResolverNode<T>> doBuild(PojoRuntimePathsBuildingHelper var1, Set<PojoModelPathValueNode> var2);

    private PojoImplicitReindexingResolverNode<T> wrapWithFilter(PojoImplicitReindexingResolverNode<T> resolver, PojoRuntimePathsBuildingHelper pathsBuildingHelper, Set<PojoModelPathValueNode> immutableDirtyPathsTriggeringReindexing) {
        PojoPathFilter filter = pathsBuildingHelper.createFilter(immutableDirtyPathsTriggeringReindexing);
        return new PojoImplicitReindexingResolverDirtinessFilterNode<T>(filter, resolver);
    }

    protected final <T2> PojoImplicitReindexingResolverNode<? super T2> createNested(Collection<? extends PojoImplicitReindexingResolverNode<? super T2>> elements) {
        int size = elements.size();
        if (size == 0) {
            return PojoImplicitReindexingResolverNode.noOp();
        }
        if (size == 1) {
            return elements.iterator().next();
        }
        return new PojoImplicitReindexingResolverMultiNode(elements);
    }
}

